/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiki;

import edu.stanford.nlp.ling.WordLemmaTag;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.Constants;
import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.util.Sets;
import it.uniroma1.lcl.jlt.wiki.data.WikiCategory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;

public class SearchWikiCategory {
    private final IndexSearcher is;
    private final SimpleFSDirectory dir;

    SearchWikiCategory() throws IOException {
        this(Language.EN);
    }

    SearchWikiCategory(Language language) throws IOException {
        this(Configuration.getInstance().getCategoryIndexDir(language));
    }

    SearchWikiCategory(String indexDir) throws IOException {
        this.dir = new SimpleFSDirectory(new File(indexDir));
        this.is = new IndexSearcher((Directory)this.dir, true);
    }

    public Hits getAllCategories() throws IOException {
        return this.is.search((Query)new MatchAllDocsQuery());
    }

    public Set<String> getAllCategoryTitles() throws IOException {
        return this.getAllCategories(Constants.WikiCategoryIndexFields.TITLE);
    }

    public Set<String> getAllCategories(Constants.WikiCategoryIndexFields field) throws IOException {
        HashSet<String> values = new HashSet<String>();
        Hits hits = this.is.search((Query)new MatchAllDocsQuery());
        int k = 0;
        while (k < hits.length()) {
            Document doc = hits.doc(k);
            values.add(doc.get(field.toString()));
            ++k;
        }
        return values;
    }

    public WikiCategory getCategoryByTitle(String title) throws IOException, ParseException {
        TermQuery tq = new TermQuery(new Term(Constants.WikiIndexFields.TITLE.toString(), title));
        Hits hits = this.is.search((Query)tq);
        Document d = null;
        if (hits.length() <= 0) {
            return null;
        }
        d = hits.doc(0);
        Set<String> superCategories = Sets.varargsToHashSet(d.getValues(Constants.WikiCategoryIndexFields.HYPERNYM.toString()));
        Set<String> subCategories = Sets.varargsToHashSet(d.getValues(Constants.WikiCategoryIndexFields.HYPONYM.toString()));
        Set<String> translations = Sets.varargsToHashSet(d.getValues(Constants.WikiCategoryIndexFields.TRANSLATION.toString()));
        String[] headsTokens = d.getValues(Constants.WikiCategoryIndexFields.HEAD_WORD.toString());
        String[] headLemmas = d.getValues(Constants.WikiCategoryIndexFields.HEAD_LEMMA.toString());
        String[] headPos = d.getValues(Constants.WikiCategoryIndexFields.HEAD_POS.toString());
        if (headsTokens.length != headLemmas.length || headsTokens.length != headPos.length) {
            throw new RuntimeException("Invalid lengths -- HEADS: " + headsTokens.length + " LEMMAS: " + headLemmas.length + " POS: " + headPos.length);
        }
        ArrayList<WordLemmaTag> heads = new ArrayList<WordLemmaTag>();
        int head = 0;
        while (head < headsTokens.length) {
            heads.add(new WordLemmaTag(headsTokens[head], headLemmas[head], headPos[head]));
            ++head;
        }
        List<String> minimalNPs = Arrays.asList(d.getValues(Constants.WikiCategoryIndexFields.MINIMAL_NP.toString()));
        String[] tokenWords = d.getValues(Constants.WikiCategoryIndexFields.TOKEN_WORD.toString());
        String[] tokenLemmas = d.getValues(Constants.WikiCategoryIndexFields.TOKEN_LEMMA.toString());
        String[] tokenPos = d.getValues(Constants.WikiCategoryIndexFields.TOKEN_POS.toString());
        if (tokenWords.length != tokenLemmas.length || tokenLemmas.length != tokenPos.length) {
            throw new RuntimeException("Invalid lengths -- TOKENS: " + tokenWords.length + " LEMMAS: " + tokenLemmas.length + " POS: " + tokenPos.length);
        }
        ArrayList<WordLemmaTag> tokens = new ArrayList<WordLemmaTag>();
        int token = 0;
        while (token < tokenWords.length) {
            tokens.add(new WordLemmaTag(tokenWords[token], tokenLemmas[token], tokenPos[token]));
            ++token;
        }
        List<String> wnLemmas = Arrays.asList(d.getValues(Constants.WikiCategoryIndexFields.WN_LEMMA.toString()));
        return new WikiCategory(d.get(Constants.WikiCategoryIndexFields.ID.toString()), d.get(Constants.WikiCategoryIndexFields.TITLE.toString()), superCategories, subCategories, translations, heads, minimalNPs, tokens, d.get(Constants.WikiCategoryIndexFields.PARSE.toString()), Boolean.parseBoolean(d.get(Constants.WikiCategoryIndexFields.CATEGORY_IN_WN.toString())), wnLemmas);
    }

    public Set<String> getSuperCategories(String title) throws IOException, ParseException {
        TermQuery tq = new TermQuery(new Term(Constants.WikiIndexFields.TITLE.toString(), title));
        Hits hits = this.is.search((Query)tq);
        Document d = null;
        if (hits.length() <= 0) {
            return null;
        }
        d = hits.doc(0);
        return Sets.varargsToHashSet(d.getValues(Constants.WikiCategoryIndexFields.HYPERNYM.toString()));
    }

    public Set<String> getSubCategories(String title) throws IOException, ParseException {
        TermQuery tq = new TermQuery(new Term(Constants.WikiIndexFields.TITLE.toString(), title));
        Hits hits = this.is.search((Query)tq);
        Document d = null;
        if (hits.length() <= 0) {
            return null;
        }
        d = hits.doc(0);
        return Sets.varargsToHashSet(d.getValues(Constants.WikiCategoryIndexFields.HYPONYM.toString()));
    }

    public List<WordLemmaTag> getCategoryTokensByTitle(String title) throws IOException, ParseException {
        TermQuery tq = new TermQuery(new Term(Constants.WikiIndexFields.TITLE.toString(), title));
        Hits hits = this.is.search((Query)tq);
        Document d = null;
        if (hits.length() <= 0) {
            return null;
        }
        d = hits.doc(0);
        String[] tokenWords = d.getValues(Constants.WikiCategoryIndexFields.TOKEN_WORD.toString());
        String[] tokenLemmas = d.getValues(Constants.WikiCategoryIndexFields.TOKEN_LEMMA.toString());
        String[] tokenPos = d.getValues(Constants.WikiCategoryIndexFields.TOKEN_POS.toString());
        if (tokenWords.length != tokenLemmas.length || tokenLemmas.length != tokenPos.length) {
            throw new RuntimeException("Invalid lengths -- TOKENS: " + tokenWords.length + " LEMMAS: " + tokenLemmas.length + " POS: " + tokenPos.length);
        }
        ArrayList<WordLemmaTag> tokens = new ArrayList<WordLemmaTag>();
        int token = 0;
        while (token < tokenWords.length) {
            tokens.add(new WordLemmaTag(tokenWords[token], tokenLemmas[token], tokenPos[token]));
            ++token;
        }
        return tokens;
    }

    public void close() throws IOException {
        this.is.close();
        this.dir.close();
    }
}

