/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiki;

import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.Pointer;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.Constants;
import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.util.UnknownLanguageException;
import it.uniroma1.lcl.jlt.wiki.data.WikiPage;
import it.uniroma1.lcl.jlt.wiki.data.WikiPageLabel;
import it.uniroma1.lcl.jlt.wiki.data.WikiText;
import it.uniroma1.lcl.jlt.wiki.data.WikiWord;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;

public class SearchWiki {
    private final IndexSearcher is;
    private final SimpleFSDirectory dir;

    public SearchWiki() throws IOException {
        this(Language.EN);
    }

    public SearchWiki(Language language) throws IOException {
        this(Configuration.getInstance().getIndexDir(language));
    }

    public SearchWiki(String indexDir) throws IOException {
        this.dir = new SimpleFSDirectory(new File(indexDir));
        this.is = new IndexSearcher((Directory)this.dir, true);
    }

    public WikiPage getPageByTitlePreserved(String title) throws IOException, ParseException {
        TermQuery tq;
        Hits hits;
        int par = title.indexOf(35);
        if (par > 0) {
            title = title.substring(0, par);
        }
        if ((hits = this.is.search((Query)(tq = new TermQuery(new Term(Constants.WikiIndexFields.TITLE.toString(), title))))).length() <= 0) {
            return null;
        }
        Document d = hits.doc(0);
        String lemma = d.get(Constants.WikiIndexFields.LEMMA.toString());
        String id = d.get(Constants.WikiIndexFields.ID.toString());
        Boolean disambiguation = Boolean.valueOf(d.get(Constants.WikiIndexFields.DISAMBIGUATION.toString()));
        d = this.getRedirection(d);
        String[] words = d.getValues(Constants.WikiIndexFields.WORD.toString());
        String[] wordSenses = d.getValues(Constants.WikiIndexFields.SENSE.toString());
        return new WikiPage(id, title, lemma, new WikiText(words, wordSenses), d.getValues(Constants.WikiIndexFields.INFOBOX_LINK.toString()), d.getValues(Constants.WikiIndexFields.TABLE_LINK.toString()), d.getValues(Constants.WikiIndexFields.CATEGORY.toString()), d.getValues(Constants.WikiIndexFields.CATEGORY_LEMMA.toString()), d.getValues(Constants.WikiIndexFields.TRANSLATION.toString()), d.getValues(Constants.WikiIndexFields.IMAGE.toString()), disambiguation);
    }

    public String getLemmaFromTitle(String title) {
        int par = (title = title.toLowerCase()).indexOf(35);
        if (par > 0) {
            title = title.substring(0, par);
        }
        if ((par = title.indexOf(40)) > 0) {
            title = title.substring(0, par - 1);
        }
        return title;
    }

    public static Language getLanguageFromTitle(String wikiTitle) throws UnknownLanguageException {
        if (wikiTitle.length() > 3 && wikiTitle.charAt(2) == ':') {
            String lang = null;
            try {
                lang = wikiTitle.substring(0, 2).toUpperCase();
                return Language.valueOf(lang);
            }
            catch (IllegalArgumentException ie) {
                throw new UnknownLanguageException("Unknown language " + lang + " in Wikipage title " + wikiTitle);
            }
        }
        return null;
    }

    public static String getTitleFromLanguageTitle(String wikiTitle) {
        if (wikiTitle.length() > 3 && wikiTitle.charAt(2) == ':') {
            return wikiTitle.substring(3);
        }
        return null;
    }

    public Hits getSenseHits(String lemma) throws IOException, ParseException {
        return this.getHits(lemma, Constants.WikiIndexFields.LEMMA, true);
    }

    public Hits getTitleHits(String title) throws IOException, ParseException {
        return this.getHits(title, Constants.WikiIndexFields.TITLE, false);
    }

    public Hits getHits(String query, Constants.WikiIndexFields field, boolean process) throws IOException, ParseException {
        if (process) {
            int par = (query = query.toLowerCase()).indexOf(35);
            if (par > 0) {
                query = query.substring(0, par);
            }
            if ((par = query.indexOf(40)) > 0) {
                query = query.substring(0, par - 1);
            }
        }
        TermQuery tq = new TermQuery(new Term(field.toString(), query));
        return this.is.search((Query)tq);
    }

    public Set<WikiPage> getSenses(String lemma) throws IOException, ParseException {
        Hits hits = this.getSenseHits(lemma);
        HashSet<WikiPage> senses = new HashSet<WikiPage>();
        HashSet<String> done = new HashSet<String>();
        int k = 0;
        while (k < hits.length()) {
            Document d = hits.doc(k);
            String id = (d = this.getRedirection(d)).get(Constants.WikiIndexFields.ID.toString());
            if (done.add(id)) {
                String[] words = d.getValues(Constants.WikiIndexFields.WORD.toString());
                String[] wordSenses = d.getValues(Constants.WikiIndexFields.SENSE.toString());
                String title = d.get(Constants.WikiIndexFields.TITLE.toString());
                Boolean disambiguation = Boolean.valueOf(d.get(Constants.WikiIndexFields.DISAMBIGUATION.toString()));
                try {
                    senses.add(new WikiPage(id, title, lemma, new WikiText(words, wordSenses), d.getValues(Constants.WikiIndexFields.INFOBOX_LINK.toString()), d.getValues(Constants.WikiIndexFields.TABLE_LINK.toString()), d.getValues(Constants.WikiIndexFields.CATEGORY.toString()), d.getValues(Constants.WikiIndexFields.CATEGORY_LEMMA.toString()), d.getValues(Constants.WikiIndexFields.TRANSLATION.toString()), d.getValues(Constants.WikiIndexFields.IMAGE.toString()), disambiguation));
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Invalid sense '" + title + "'", e);
                }
            }
            ++k;
        }
        return senses;
    }

    public Set<String> getPageTitlesByCategoryTitle(String category) throws IOException, ParseException {
        return this.getPageTitlesByCategory(category, Constants.WikiIndexFields.CATEGORY);
    }

    public Set<WikiPage> getPagesByCategoryTitle(String category) throws IOException, ParseException {
        return this.getPagesByCategory(category, Constants.WikiIndexFields.CATEGORY);
    }

    public Set<String> getPageTitlesByCategoryLemma(String category) throws IOException, ParseException {
        return this.getPageTitlesByCategory(category, Constants.WikiIndexFields.CATEGORY_LEMMA);
    }

    public Set<WikiPage> getPagesByCategoryLemma(String category) throws IOException, ParseException {
        return this.getPagesByCategory(category, Constants.WikiIndexFields.CATEGORY_LEMMA);
    }

    private Set<String> getPageTitlesByCategory(String category, Constants.WikiIndexFields field) throws IOException, ParseException {
        if (field.equals((Object)Constants.WikiIndexFields.CATEGORY_LEMMA)) {
            category = category.toLowerCase();
        }
        TermQuery tq = new TermQuery(new Term(field.toString(), category));
        Hits hits = this.is.search((Query)tq);
        HashSet<String> titles = new HashSet<String>();
        HashSet<String> done = new HashSet<String>();
        int k = 0;
        while (k < hits.length()) {
            Document d = hits.doc(k);
            String id = (d = this.getRedirection(d)).get(Constants.WikiIndexFields.ID.toString());
            if (done.add(id)) {
                titles.add(d.get(Constants.WikiIndexFields.TITLE.toString()));
            }
            ++k;
        }
        return titles;
    }

    private Set<WikiPage> getPagesByCategory(String category, Constants.WikiIndexFields field) throws IOException, ParseException {
        if (field.equals((Object)Constants.WikiIndexFields.CATEGORY_LEMMA)) {
            category = category.toLowerCase();
        }
        TermQuery tq = new TermQuery(new Term(field.toString(), category));
        Hits hits = this.is.search((Query)tq);
        HashSet<WikiPage> pages = new HashSet<WikiPage>();
        HashSet<String> done = new HashSet<String>();
        int k = 0;
        while (k < hits.length()) {
            Document d = hits.doc(k);
            String id = (d = this.getRedirection(d)).get(Constants.WikiIndexFields.ID.toString());
            if (done.add(id)) {
                String title = d.get(Constants.WikiIndexFields.TITLE.toString());
                String lemma = d.get(Constants.WikiIndexFields.LEMMA.toString());
                String[] words = d.getValues(Constants.WikiIndexFields.WORD.toString());
                String[] wordSenses = d.getValues(Constants.WikiIndexFields.SENSE.toString());
                Boolean disambiguation = Boolean.valueOf(d.get(Constants.WikiIndexFields.DISAMBIGUATION.toString()));
                pages.add(new WikiPage(id, title, lemma, new WikiText(words, wordSenses), d.getValues(Constants.WikiIndexFields.INFOBOX_LINK.toString()), d.getValues(Constants.WikiIndexFields.TABLE_LINK.toString()), d.getValues(Constants.WikiIndexFields.CATEGORY.toString()), d.getValues(Constants.WikiIndexFields.CATEGORY_LEMMA.toString()), d.getValues(Constants.WikiIndexFields.TRANSLATION.toString()), d.getValues(Constants.WikiIndexFields.IMAGE.toString()), disambiguation));
            }
            ++k;
        }
        return pages;
    }

    public Set<String> getSenseTitles(String lemma) throws IOException, ParseException {
        int par = (lemma = lemma.toLowerCase()).indexOf(35);
        if (par > 0) {
            lemma = lemma.substring(0, par);
        }
        if ((par = lemma.indexOf(40)) > 0) {
            lemma = lemma.substring(0, par - 1);
        }
        TermQuery tq = new TermQuery(new Term(Constants.WikiIndexFields.LEMMA.toString(), lemma));
        Hits hits = this.is.search((Query)tq);
        HashSet<String> senses = new HashSet<String>();
        HashSet<String> done = new HashSet<String>();
        int k = 0;
        while (k < hits.length()) {
            Document d = hits.doc(k);
            String id = (d = this.getRedirection(d)).get(Constants.WikiIndexFields.ID.toString());
            if (done.add(id)) {
                senses.add(d.get(Constants.WikiIndexFields.TITLE.toString()));
            }
            ++k;
        }
        return senses;
    }

    public int getNumberOfSenses(String lemma) throws IOException, ParseException {
        return this.getSenses(lemma).size();
    }

    public WikiPage getPageById(String id) throws IOException, ParseException {
        TermQuery tq = new TermQuery(new Term(Constants.WikiIndexFields.ID.toString(), id));
        Hits hits = this.is.search((Query)tq);
        if (hits.length() == 0) {
            return null;
        }
        Document d = hits.doc(0);
        String title = d.get(Constants.WikiIndexFields.TITLE.toString());
        String lemma = d.get(Constants.WikiIndexFields.LEMMA.toString());
        String[] words = d.getValues(Constants.WikiIndexFields.WORD.toString());
        String[] wordSenses = d.getValues(Constants.WikiIndexFields.SENSE.toString());
        Boolean disambiguation = Boolean.valueOf(d.get(Constants.WikiIndexFields.DISAMBIGUATION.toString()));
        return new WikiPage(id, title, lemma, new WikiText(words, wordSenses), d.getValues(Constants.WikiIndexFields.INFOBOX_LINK.toString()), d.getValues(Constants.WikiIndexFields.TABLE_LINK.toString()), d.getValues(Constants.WikiIndexFields.CATEGORY.toString()), d.getValues(Constants.WikiIndexFields.CATEGORY_LEMMA.toString()), d.getValues(Constants.WikiIndexFields.TRANSLATION.toString()), d.getValues(Constants.WikiIndexFields.IMAGE.toString()), disambiguation);
    }

    public int getMaxId() throws IOException, ParseException {
        int idNumber = 0;
        int tempIdNumber = 0;
        int k = 0;
        while (k < this.is.maxDoc()) {
            Document doc = this.is.doc(k);
            String id = doc.get(Constants.WikiIndexFields.ID.toString());
            tempIdNumber = Integer.parseInt(id);
            if (idNumber < tempIdNumber) {
                idNumber = tempIdNumber;
            }
            ++k;
        }
        return idNumber;
    }

    public Hits getAllPages() throws IOException {
        return this.is.search((Query)new MatchAllDocsQuery());
    }

    public Hits getAllPages(Sort sort) throws IOException {
        return this.is.search((Query)new MatchAllDocsQuery(), sort);
    }

    public Set<String> getAllPageLemmas() throws IOException {
        HashSet<String> titles = new HashSet<String>();
        Hits hits = this.is.search((Query)new MatchAllDocsQuery());
        int k = 0;
        while (k < hits.length()) {
            Document doc = hits.doc(k);
            titles.add(doc.get(Constants.WikiIndexFields.LEMMA.toString()));
            ++k;
        }
        return titles;
    }

    public void getAllAmbiguousPageLemmas() throws IOException, ParseException {
        HashSet<String> done = new HashSet<String>();
        Hits hits = this.is.search((Query)new MatchAllDocsQuery());
        int k = 0;
        while (k < hits.length()) {
            Document doc = hits.doc(k);
            String lemma = doc.get(Constants.WikiIndexFields.LEMMA.toString());
            String title = doc.get(Constants.WikiIndexFields.TITLE.toString());
            int idx = title.indexOf(40);
            if (idx > 0) {
                title = title.substring(0, idx - 1);
            }
            if (title.equalsIgnoreCase(lemma)) {
                HashSet<String> titles = new HashSet<String>();
                try {
                    for (WikiPage wp : this.getSenses(lemma)) {
                        String t = wp.getTitle();
                        int idx2 = t.indexOf(40);
                        if (idx2 > 0) {
                            t = t.substring(0, idx2 - 1);
                        }
                        if (!t.equalsIgnoreCase(lemma)) continue;
                        titles.add(this.getRedirectionTitle(wp.getTitle()).toLowerCase());
                    }
                    if (titles.size() > 1 && !done.contains(title)) {
                        done.add(title);
                        System.out.println(title);
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
            ++k;
        }
    }

    public List<String> getAllOrderedPageTitles() throws IOException {
        TopFieldDocs docs = this.is.search((Query)new MatchAllDocsQuery(), null, this.is.getIndexReader().numDocs(), new Sort(new SortField(Constants.WikiIndexFields.TITLE.toString())));
        ArrayList<String> ordered = new ArrayList<String>(docs.totalHits);
        int i = 0;
        while (i < docs.totalHits) {
            Document doc = this.is.doc(docs.scoreDocs[i].doc);
            ordered.add(doc.get(Constants.WikiIndexFields.TITLE.toString()));
            ++i;
        }
        return ordered;
    }

    public Set<String> getAllPageTitles() throws IOException {
        HashSet<String> titles = new HashSet<String>();
        Hits hits = this.is.search((Query)new MatchAllDocsQuery());
        int k = 0;
        while (k < hits.length()) {
            Document doc = hits.doc(k);
            titles.add(doc.get(Constants.WikiIndexFields.TITLE.toString()));
            ++k;
        }
        return titles;
    }

    public Set<String> getPageTitlesContainingSense(String title) throws IOException {
        int par = title.indexOf(35);
        if (par > 0) {
            title = title.substring(0, par);
        }
        TermQuery tq = new TermQuery(new Term(Constants.WikiIndexFields.SENSE.toString(), title));
        Hits hits = this.is.search((Query)tq);
        HashSet<String> titles = new HashSet<String>();
        int k = 0;
        while (k < hits.length()) {
            Document d = hits.doc(k);
            titles.add(d.get(Constants.WikiIndexFields.TITLE.toString()));
            ++k;
        }
        return titles;
    }

    public Set<String> getLinksOfPagesContainingSense(String title) throws IOException {
        int par = title.indexOf(35);
        if (par > 0) {
            title = title.substring(0, par);
        }
        TermQuery tq = new TermQuery(new Term(Constants.WikiIndexFields.SENSE.toString(), title));
        Hits hits = this.is.search((Query)tq);
        HashSet<String> links = new HashSet<String>();
        int k = 0;
        while (k < hits.length()) {
            Document d = hits.doc(k);
            String[] stringArray = d.getValues(Constants.WikiIndexFields.SENSE.toString());
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String link = stringArray[n2];
                if (!link.isEmpty()) {
                    links.add(link);
                }
                ++n2;
            }
            ++k;
        }
        return links;
    }

    public List<String> getPageTextByTitle(String title) throws IOException, ParseException {
        TermQuery tq;
        Hits hits;
        int par = title.indexOf(35);
        if (par > 0) {
            title = title.substring(0, par);
        }
        if ((hits = this.is.search((Query)(tq = new TermQuery(new Term(Constants.WikiIndexFields.TITLE.toString(), title))))).length() <= 0) {
            return null;
        }
        Document d = hits.doc(0);
        d = this.getRedirection(d);
        String[] words = d.getValues(Constants.WikiIndexFields.WORD.toString());
        if (words == null) {
            return null;
        }
        return Arrays.asList(words);
    }

    public WikiPage getPageByTitle(String title) throws IOException, ParseException {
        TermQuery tq;
        Hits hits;
        int par = title.indexOf(35);
        if (par > 0) {
            title = title.substring(0, par);
        }
        if ((hits = this.is.search((Query)(tq = new TermQuery(new Term(Constants.WikiIndexFields.TITLE.toString(), title))))).length() <= 0) {
            return null;
        }
        Document d = hits.doc(0);
        d = this.getRedirection(d);
        String id = d.get(Constants.WikiIndexFields.ID.toString());
        String title2 = d.get(Constants.WikiIndexFields.TITLE.toString());
        String lemma = d.get(Constants.WikiIndexFields.LEMMA.toString());
        String[] words = d.getValues(Constants.WikiIndexFields.WORD.toString());
        String[] wordSenses = d.getValues(Constants.WikiIndexFields.SENSE.toString());
        Boolean disambiguation = Boolean.valueOf(d.get(Constants.WikiIndexFields.DISAMBIGUATION.toString()));
        return new WikiPage(id, title2, lemma, new WikiText(words, wordSenses), d.getValues(Constants.WikiIndexFields.INFOBOX_LINK.toString()), d.getValues(Constants.WikiIndexFields.TABLE_LINK.toString()), d.getValues(Constants.WikiIndexFields.CATEGORY.toString()), d.getValues(Constants.WikiIndexFields.CATEGORY_LEMMA.toString()), d.getValues(Constants.WikiIndexFields.TRANSLATION.toString()), d.getValues(Constants.WikiIndexFields.IMAGE.toString()), disambiguation);
    }

    public String getPageLemmaByTitle(String title) throws IOException, ParseException {
        return this.getPageLemmaByTitle(title, true);
    }

    public String getPageLemmaByTitle(String title, boolean bFollowRedirection) throws IOException, ParseException {
        TermQuery tq;
        Hits hits;
        int par = title.indexOf(35);
        if (par > 0) {
            title = title.substring(0, par);
        }
        if ((hits = this.is.search((Query)(tq = new TermQuery(new Term(Constants.WikiIndexFields.TITLE.toString(), title))))).length() <= 0) {
            return null;
        }
        Document d = hits.doc(0);
        if (bFollowRedirection) {
            d = this.getRedirection(d);
        }
        return d.get(Constants.WikiIndexFields.LEMMA.toString());
    }

    public WikiPage getPageByTitleToLowerCase(String title) throws IOException, ParseException {
        TermQuery tq;
        Hits hits;
        int par = title.indexOf(35);
        if (par > 0) {
            title = title.substring(0, par);
        }
        if ((hits = this.is.search((Query)(tq = new TermQuery(new Term(Constants.WikiIndexFields.TITLE_TOLOWERCASE.toString(), title))))).length() <= 0) {
            return null;
        }
        Document d = hits.doc(0);
        d = this.getRedirection(d);
        String id = d.get(Constants.WikiIndexFields.ID.toString());
        String title2 = d.get(Constants.WikiIndexFields.TITLE.toString());
        String lemma = d.get(Constants.WikiIndexFields.LEMMA.toString());
        String[] words = d.getValues(Constants.WikiIndexFields.WORD.toString());
        String[] wordSenses = d.getValues(Constants.WikiIndexFields.SENSE.toString());
        Boolean disambiguation = Boolean.valueOf(d.get(Constants.WikiIndexFields.DISAMBIGUATION.toString()));
        return new WikiPage(id, title2, lemma, new WikiText(words, wordSenses), d.getValues(Constants.WikiIndexFields.INFOBOX_LINK.toString()), d.getValues(Constants.WikiIndexFields.TABLE_LINK.toString()), d.getValues(Constants.WikiIndexFields.CATEGORY.toString()), d.getValues(Constants.WikiIndexFields.CATEGORY_LEMMA.toString()), d.getValues(Constants.WikiIndexFields.TRANSLATION.toString()), d.getValues(Constants.WikiIndexFields.IMAGE.toString()), disambiguation);
    }

    public Set<String> getLemmasPointingTo(String title) throws IOException, ParseException {
        int par = title.indexOf(35);
        if (par > 0) {
            title = title.substring(0, par);
        }
        TermQuery tq = new TermQuery(new Term(Constants.WikiIndexFields.SENSE.toString(), title));
        Hits hits = this.is.search((Query)tq);
        HashSet<String> words = new HashSet<String>();
        int k = 0;
        while (k < hits.length()) {
            words.add(hits.doc(k).get(Constants.WikiIndexFields.LEMMA.toString()));
            ++k;
        }
        return words;
    }

    public boolean isRedirection(String title) throws IOException {
        TermQuery tq;
        Hits hits;
        int par = title.indexOf(35);
        if (par > 0) {
            title = title.substring(0, par);
        }
        if ((hits = this.is.search((Query)(tq = new TermQuery(new Term(Constants.WikiIndexFields.TITLE.toString(), title))))).length() <= 0) {
            return false;
        }
        Document d = hits.doc(0);
        String redirezione = d.get(Constants.WikiIndexFields.REDIRECTION.toString());
        return redirezione != null;
    }

    public Set<String> getPageCategoryTitles(String title) throws IOException, ParseException {
        TermQuery tq;
        Hits hits;
        int par = title.indexOf(35);
        if (par > 0) {
            title = title.substring(0, par);
        }
        if ((hits = this.is.search((Query)(tq = new TermQuery(new Term(Constants.WikiIndexFields.TITLE.toString(), title))))).length() <= 0) {
            return null;
        }
        Document d = hits.doc(0);
        HashSet<String> categories = new HashSet<String>();
        String[] categoryArray = d.getValues(Constants.WikiIndexFields.CATEGORY.toString());
        if (categoryArray != null) {
            String[] stringArray = categoryArray;
            int n = categoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                String category = stringArray[n2];
                categories.add(category);
                ++n2;
            }
        }
        return categories;
    }

    public WikiPage getRandomPage(Constants.PageType type) throws CorruptIndexException, IOException, ParseException {
        Random r = new Random();
        Document d = new Document();
        Boolean containsAmbiguousWords = false;
        WikiPage currentWikiPage = null;
        String lemmaPartOfSense = new String();
        block0: do {
            d = this.is.doc(r.nextInt(this.is.maxDoc()));
            d = this.getRedirection(d);
            String[] wordSenses = d.getValues(Constants.WikiIndexFields.SENSE.toString());
            String[] words = d.getValues(Constants.WikiIndexFields.WORD.toString());
            if (wordSenses == null || words == null) continue;
            String lemma = d.get(Constants.WikiIndexFields.LEMMA.toString());
            IIndexWord iw = WordNet.getInstance().getIndexWord(lemma, POS.NOUN);
            boolean bInstance = false;
            boolean bConcept = false;
            if (iw == null) {
                bInstance = true;
            } else {
                for (ISynset synset : WordNet.getInstance().getSynsets(iw)) {
                    if (!synset.getRelatedSynsets((IPointer)Pointer.HYPERNYM_INSTANCE).isEmpty()) {
                        bInstance = true;
                        continue;
                    }
                    bConcept = true;
                }
            }
            if (bInstance && bConcept || bInstance && type == Constants.PageType.CONCEPT || bConcept && type == Constants.PageType.INSTANCE) continue;
            System.out.println(lemma);
            String id = d.get(Constants.WikiIndexFields.ID.toString());
            String title2 = d.get(Constants.WikiIndexFields.TITLE.toString());
            Boolean disambiguation = Boolean.valueOf(d.get(Constants.WikiIndexFields.DISAMBIGUATION.toString()));
            currentWikiPage = new WikiPage(id, title2, lemma, new WikiText(words, wordSenses), d.getValues(Constants.WikiIndexFields.INFOBOX_LINK.toString()), d.getValues(Constants.WikiIndexFields.TABLE_LINK.toString()), d.getValues(Constants.WikiIndexFields.CATEGORY.toString()), d.getValues(Constants.WikiIndexFields.CATEGORY_LEMMA.toString()), d.getValues(Constants.WikiIndexFields.TRANSLATION.toString()), d.getValues(Constants.WikiIndexFields.IMAGE.toString()), disambiguation);
            if (currentWikiPage.getText() == null) continue;
            for (WikiWord ww : currentWikiPage.getText().getWikiWords()) {
                lemmaPartOfSense = ww.getWikiSense();
                int par = lemmaPartOfSense.indexOf("#");
                if (par > 0) {
                    lemmaPartOfSense = lemmaPartOfSense.substring(par - 1);
                }
                if ((par = lemmaPartOfSense.indexOf("(")) > 0) {
                    lemmaPartOfSense = lemmaPartOfSense.substring(par - 1);
                }
                if (this.getNumberOfSenses(ww.getWikiSense()) <= 1 || lemmaPartOfSense.equalsIgnoreCase(currentWikiPage.getLemma())) continue;
                containsAmbiguousWords = true;
                continue block0;
            }
        } while (!containsAmbiguousWords.booleanValue());
        return currentWikiPage;
    }

    public Set<WikiPage> getRandomPageSet(Constants.PageType type, int numberOfPages) throws CorruptIndexException, IOException, ParseException {
        HashSet<WikiPage> result = new HashSet<WikiPage>();
        WikiPage wp = null;
        while (numberOfPages > 0) {
            System.out.println(numberOfPages);
            wp = this.getRandomPage(type);
            if (this.getAmbiguousRandomWord(wp.getText(), wp.getLemma()) == null || !result.add(wp)) continue;
            --numberOfPages;
        }
        return result;
    }

    public ArrayList<WikiWord> getWordSet(WikiText wt, String sourcePageLemma, Constants.WordType type) throws IOException, ParseException {
        ArrayList<WikiWord> result = new ArrayList<WikiWord>();
        for (WikiWord ww : wt.getWikiWords()) {
            String senso;
            WikiPage wp;
            String testo = ww.getWikiText();
            int par = testo.indexOf("(");
            if (par > 0) {
                if (testo.charAt(par - 1) != ' ') continue;
                testo = testo.substring(0, par - 1);
            }
            if ((wp = this.getPageByTitle(senso = ww.getWikiSense())) == null) continue;
            senso = wp.getTitle();
            par = senso.indexOf("(");
            if (par > 0) {
                if (senso.charAt(par - 1) != ' ') continue;
                senso = senso.substring(0, par - 1);
            }
            if (senso.equalsIgnoreCase(sourcePageLemma) || testo.equalsIgnoreCase(sourcePageLemma) || !testo.equals(senso) || type != Constants.WordType.ALL && this.getNumberOfSenses(senso) <= 1) continue;
            result.add(ww);
        }
        return result;
    }

    public WikiWord getAmbiguousRandomWord(WikiText wt, String sourcePageLemma) throws IOException, ParseException {
        Random r = new Random();
        ArrayList<WikiWord> listWw = this.getWordSet(wt, sourcePageLemma, Constants.WordType.AMBIGUOUS);
        WikiWord result = null;
        if (listWw.size() < 1) {
            return null;
        }
        int n = listWw.size() > 1 ? r.nextInt(listWw.size()) : 1;
        Iterator<WikiWord> iterator = listWw.iterator();
        while (iterator.hasNext()) {
            WikiWord w;
            result = w = iterator.next();
            if (--n == 0) break;
        }
        return result;
    }

    public Set<String> getPagesContaining(String titolo, String senso) throws CorruptIndexException, IOException {
        HashSet<String> pages = new HashSet<String>();
        if (titolo != null && senso != null) {
            int k = 0;
            while (k < this.is.maxDoc()) {
                String[] arrayTesto;
                Document doc = this.is.doc(k);
                String pagina = doc.get(Constants.WikiIndexFields.TITLE_TOLOWERCASE.toString());
                if (!pagina.equals(titolo) && !pagina.equals(senso) && (arrayTesto = doc.getValues(Constants.WikiIndexFields.WORD.toString())) != null) {
                    ArrayList<String> testo = new ArrayList<String>();
                    String[] stringArray = arrayTesto;
                    int n = arrayTesto.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String t = stringArray[n2];
                        testo.add(t);
                        ++n2;
                    }
                    if (testo.contains(titolo) && testo.contains(senso)) {
                        pages.add(pagina);
                    }
                }
                ++k;
            }
        }
        return pages;
    }

    public IndexSearcher getIndexSearcher() {
        return this.is;
    }

    public Document getRedirection(Document d) throws IOException {
        HashSet<String> titlesDone = new HashSet<String>();
        while (d != null) {
            Document firstHit;
            String firstHitTitle;
            int idx;
            String title = d.get(Constants.WikiIndexFields.TITLE.toString());
            int par = title.indexOf(35);
            if (par > 0) {
                title = title.substring(0, par);
            }
            title = title.replaceAll("_", " ");
            titlesDone.add(title);
            String redirezione = d.get(Constants.WikiIndexFields.REDIRECTION.toString());
            if (redirezione == null) {
                return d;
            }
            int par2 = redirezione.indexOf(35);
            if (par2 > 0) {
                redirezione = redirezione.substring(0, par2);
            }
            if ((redirezione = redirezione.replaceAll("_", " ")).startsWith(":")) {
                redirezione = redirezione.substring(1);
            }
            if ((idx = redirezione.indexOf("|")) != -1) {
                redirezione = redirezione.substring(0, idx);
            }
            BooleanQuery bq = new BooleanQuery();
            bq.add(new BooleanClause((Query)new TermQuery(new Term(Constants.WikiIndexFields.TITLE.toString(), redirezione)), BooleanClause.Occur.SHOULD));
            bq.add(new BooleanClause((Query)new TermQuery(new Term(Constants.WikiIndexFields.TITLE_TOLOWERCASE.toString(), redirezione)), BooleanClause.Occur.SHOULD));
            Hits hits = this.is.search((Query)bq);
            if (hits.length() <= 0 || titlesDone.contains(firstHitTitle = (firstHit = hits.doc(0)).get(Constants.WikiIndexFields.TITLE.toString()))) break;
            d = hits.doc(0);
        }
        return d;
    }

    public String getRedirectionTitle(String target) throws IOException {
        TermQuery tq = new TermQuery(new Term(Constants.WikiIndexFields.TITLE.toString(), target));
        Hits hits = this.is.search((Query)tq);
        if (hits.length() > 0) {
            Document d = this.getRedirection(hits.doc(0));
            return d.get(Constants.WikiIndexFields.TITLE.toString());
        }
        return target;
    }

    public Set<String> getLemmasFromRedirectionsToThisPage(String title) throws IOException {
        HashSet<String> lemmas = new HashSet<String>();
        TermQuery tq = new TermQuery(new Term(Constants.WikiIndexFields.REDIRECTION.toString(), title));
        Hits hits = this.is.search((Query)tq);
        int k = 0;
        while (k < hits.length()) {
            Document hit = hits.doc(k);
            lemmas.add(hit.get("lemma"));
            ++k;
        }
        return lemmas;
    }

    public String getPageTextFromTitle(String title) throws IOException {
        TermQuery query = new TermQuery(new Term(Constants.WikiIndexFields.TITLE.toString(), title));
        TopDocs rs = this.is.search((Query)query, null, 1);
        if (rs.totalHits > 0) {
            Document doc = this.is.doc(rs.scoreDocs[0].doc);
            long start = Long.parseLong(doc.get(Constants.WikiIndexFields.OFFSET_START.toString()));
            long end = Long.parseLong(doc.get(Constants.WikiIndexFields.OFFSET_END.toString()));
            return this.getPageText(start, end - 1L);
        }
        return null;
    }

    public String getPageText(long start, long end) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(Configuration.getInstance().getWikipediaXMLDump(), "r");
        raf.seek(start);
        byte[] text = new byte[(int)(end - start + 1L)];
        raf.read(text);
        raf.close();
        return new String(text, Charset.forName("UTF-8"));
    }

    public Set<String> getTitlesFromRedirectionsToThisPage(String title) throws IOException {
        HashSet<String> titles = new HashSet<String>();
        TermQuery tq = new TermQuery(new Term(Constants.WikiIndexFields.REDIRECTION.toString(), title));
        Hits hits = this.is.search((Query)tq);
        int k = 0;
        while (k < hits.length()) {
            Document hit = hits.doc(k);
            titles.add(hit.get(Constants.WikiIndexFields.TITLE.toString()));
            ++k;
        }
        return titles;
    }

    public List<WikiPageLabel> getMostFrequentPageLabels() throws IOException {
        HashMap<String, WikiPageLabel> label2label = new HashMap<String, WikiPageLabel>();
        Hits hits = this.is.search((Query)new MatchAllDocsQuery());
        int k = 0;
        while (k < hits.length()) {
            Document d = hits.doc(k);
            String title = d.get(Constants.WikiIndexFields.TITLE_TOLOWERCASE.toString());
            int idx = title.indexOf(" (");
            if (idx != -1) {
                WikiPageLabel label;
                if ((title = title.substring(idx + 2)).endsWith(")")) {
                    title = title.substring(0, title.length() - 1);
                }
                if ((label = (WikiPageLabel)label2label.get(title)) == null) {
                    label = new WikiPageLabel(title);
                    label2label.put(title, label);
                }
                label.incrementFrequency();
            }
            ++k;
        }
        ArrayList labels = new ArrayList(label2label.values());
        Collections.sort(labels);
        return labels.subList(0, 500);
    }

    public Set<WikiPage> getPagesFromExternalFile(String filename) throws IOException, ParseException {
        HashSet<WikiPage> wpSet;
        block14: {
            wpSet = new HashSet<WikiPage>();
            BufferedReader dsFile = null;
            try {
                try {
                    dsFile = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
                    String linea = dsFile.readLine();
                    while (linea != null) {
                        WikiPage wp = this.getPageByTitle(linea);
                        if (wp != null) {
                            wpSet.add(wp);
                        }
                        linea = dsFile.readLine();
                    }
                }
                catch (FileNotFoundException fnf) {
                    System.err.println("FileNotFoundException: " + fnf.getMessage());
                    if (dsFile == null) break block14;
                    try {
                        dsFile.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (dsFile != null) {
                    try {
                        dsFile.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return wpSet;
    }

    public Set<String> getPagesPointingTo(String title) throws IOException {
        WikiPage page = null;
        try {
            page = this.getPageByTitle(title);
        }
        catch (ParseException e) {
            throw new RuntimeException("Cannot find page: " + title);
        }
        String pTitle = page.getTitle();
        BooleanQuery bq = new BooleanQuery();
        bq.add(new BooleanClause((Query)new TermQuery(new Term(Constants.WikiIndexFields.SENSE.toString(), pTitle)), BooleanClause.Occur.SHOULD));
        bq.add(new BooleanClause((Query)new TermQuery(new Term(Constants.WikiIndexFields.SENSE.toString(), pTitle.toLowerCase())), BooleanClause.Occur.SHOULD));
        Hits hits = this.is.search((Query)bq);
        HashSet<String> titles = new HashSet<String>();
        int k = 0;
        while (k < hits.length()) {
            titles.add(hits.doc(k).get(Constants.WikiIndexFields.TITLE.toString()));
            ++k;
        }
        return titles;
    }

    public String[] getTranslations(String title) throws IOException {
        return this.getTranslations(title, true);
    }

    public String[] getTranslations(String title, boolean followRedirection) throws IOException {
        String[] values = null;
        TermQuery query = new TermQuery(new Term(Constants.WikiIndexFields.TITLE.toString(), title));
        TopDocs rs = this.is.search((Query)query, null, 1);
        if (rs.totalHits > 0) {
            Document d = this.is.doc(rs.scoreDocs[0].doc);
            if (followRedirection) {
                d = this.getRedirection(d);
            }
            values = d.getValues(Constants.WikiIndexFields.TRANSLATION.toString());
        }
        return values;
    }

    public Set<String> getTranslations(String title, Language language) throws IOException {
        return this.getTranslations(title, language, true);
    }

    public Set<String> getTranslations(String title, Language language, boolean followRedirection) throws IOException {
        String[] values = null;
        HashSet<String> translations = new HashSet<String>();
        TermQuery query = new TermQuery(new Term(Constants.WikiIndexFields.TITLE.toString(), title));
        TopDocs rs = this.is.search((Query)query, null, 1);
        if (rs.totalHits > 0) {
            Document d = this.is.doc(rs.scoreDocs[0].doc);
            if (followRedirection) {
                d = this.getRedirection(d);
            }
            String[] stringArray = values = d.getValues(Constants.WikiIndexFields.TRANSLATION.toString());
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    String value = stringArray[n2];
                    Language languageFromTitle = null;
                    try {
                        languageFromTitle = SearchWiki.getLanguageFromTitle(value);
                    }
                    catch (UnknownLanguageException ule) {
                        break block6;
                    }
                    if (languageFromTitle == language) {
                        translations.add(value);
                    }
                }
                ++n2;
            }
        }
        return translations;
    }

    public String[] getValuesFromField(String field, String lemma) throws IOException {
        String[] v = null;
        TermQuery query = new TermQuery(new Term(Constants.WikiIndexFields.LEMMA.toString(), lemma));
        TopDocs rs = this.is.search((Query)query, null, 1);
        if (rs.totalHits > 0) {
            Document d = this.is.doc(rs.scoreDocs[0].doc);
            v = d.getValues(field);
        }
        return v;
    }

    public HashSet<String> getValuesFromField(String field) throws IOException {
        HashSet<String> s = new HashSet<String>();
        Document d = null;
        IndexReader ir = this.is.getIndexReader();
        int i = 0;
        while (i < ir.numDocs()) {
            String[] v;
            d = ir.document(i);
            String[] stringArray = v = d.getValues(field);
            int n = v.length;
            int n2 = 0;
            while (n2 < n) {
                String x = stringArray[n2];
                s.add(x);
                ++n2;
            }
            ++i;
        }
        return s;
    }

    public Set<Document> getDocuments(int n) throws IOException {
        HashSet<Document> documents = new HashSet<Document>();
        IndexReader ir = this.is.getIndexReader();
        int i = 0;
        while (i < n && i < ir.numDocs()) {
            documents.add(ir.document(i));
            ++i;
        }
        return documents;
    }

    public void close() throws IOException {
        this.is.close();
        this.dir.close();
    }

    public void closeIndex() throws IOException {
        this.close();
    }

    public static void main(String[] args) throws IOException, ParseException {
        try {
            String query = "";
            Language language = null;
            String languageString = "";
            Scanner scanner = new Scanner(System.in);
            HashMap<Language, SearchWiki> sws = new HashMap<Language, SearchWiki>();
            while (true) {
                System.out.println("Enter page you want to inspect [\"exit\" or empty string to exit]: ");
                query = scanner.nextLine();
                if (query.isEmpty() || query.toLowerCase().equals("exit")) break;
                System.out.println("Enter enter the language of interest: ");
                languageString = scanner.nextLine();
                try {
                    language = Language.valueOf(languageString);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Language " + languageString + " is not available, please retry...");
                    continue;
                }
                SearchWiki sw = (SearchWiki)sws.get((Object)language);
                if (sw == null) {
                    try {
                        sw = new SearchWiki(language);
                    }
                    catch (IOException e) {
                        System.err.println("Language " + languageString + " is not available, please retry...");
                        continue;
                    }
                    sws.put(language, sw);
                }
                System.out.println("LOOKING FOR PAGE TITLED AS " + query);
                WikiPage page = sw.getPageByTitle(query);
                if (page != null) {
                    System.out.println("---------------");
                    System.out.println("IS REDIRECTION? " + sw.isRedirection(query));
                    System.out.println("---------------");
                    System.out.println("PAGE FOLLOWS:");
                    System.out.println("\tid=" + page.getId());
                    System.out.println("\ttitle=" + page.getTitle());
                    System.out.println("\tcategories=" + page.getCategories());
                    System.out.println("\tcategory lemmas=" + page.getCategoryLemmas());
                    System.out.println("\timages=" + page.getImages());
                    System.out.println("\ttranslations=" + page.getTranslations());
                    System.out.println("\tdisambiguation=" + page.isDisambiguation());
                    System.out.println("---------------");
                    continue;
                }
                System.out.println("PAGE NOT FOUND");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

