/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiki;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.wiki.IndexWikiThread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;

public class IndexWiki {
    private static final Log log = LogFactory.getLog(IndexWiki.class);
    private int startDir;
    private int endDir;
    private String indexDir;
    private static Configuration config = Configuration.getInstance();
    private HashSet<String> lexicon = new HashSet();
    private File[] jobList = null;
    private static int currJob = 0;
    private int numThread = 1;

    public IndexWiki() {
        this.startDir = config.getIndexStartDir();
        this.endDir = config.getIndexEndDir();
        this.indexDir = config.getIndexFactoryDir();
        this.numThread = config.getIndexNumThreads();
    }

    public void index() {
        String docDir = String.valueOf(config.getDocDir()) + File.separator + (Object)((Object)config.getIndexFactoryLanguage());
        log.info((Object)("::Creating the index from doc dir: " + docDir + " with " + config.getIndexNumThreads() + " threads."));
        String linea = null;
        IndexWriter writer = null;
        SimpleFSDirectory dir = null;
        try {
            try {
                StandardAnalyzer standardAnalyzer = new StandardAnalyzer(Version.LUCENE_29);
                dir = new SimpleFSDirectory(new File(this.indexDir));
                writer = new IndexWriter((Directory)dir, (Analyzer)standardAnalyzer, IndexWriter.MaxFieldLength.UNLIMITED);
                writer.setMaxMergeDocs(config.getMaxMergeDocs());
                String lex = config.getLexiconFileName();
                BufferedReader brLexicon = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(String.valueOf(docDir) + "/" + lex), "UTF-8"));
                while ((linea = brLexicon.readLine()) != null) {
                    this.lexicon.add(linea);
                }
                brLexicon.close();
                this.createJobList(docDir);
                ExecutorService threadExecutor = Executors.newFixedThreadPool(this.numThread);
                CountDownLatch doneSignal = new CountDownLatch(this.numThread);
                int i = 0;
                while (i < this.numThread) {
                    IndexWikiThread worker = new IndexWikiThread(this, writer, this.startDir, this.endDir, this.lexicon, docDir, doneSignal);
                    threadExecutor.execute(worker);
                    ++i;
                }
                try {
                    doneSignal.await();
                    threadExecutor.shutdown();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                log.info((Object)"OPTIMIZING the index");
                writer.optimize();
            }
            catch (IOException e) {
                log.info((Object)("[MAIN] " + e.getMessage()));
                try {
                    writer.close();
                    dir.close();
                }
                catch (IOException e2) {
                    log.info((Object)("[MAIN] " + e2));
                }
            }
        }
        finally {
            try {
                writer.close();
                dir.close();
            }
            catch (IOException e) {
                log.info((Object)("[MAIN] " + e));
            }
        }
    }

    private boolean createJobList(String docDir) {
        File f = new File(docDir);
        boolean t = true;
        if (f.exists()) {
            this.jobList = new File(docDir).listFiles();
        } else {
            t = false;
        }
        return t;
    }

    public synchronized File getJob() {
        File f = null;
        if (currJob + 1 > this.jobList.length) {
            return null;
        }
        f = this.jobList[currJob];
        ++currJob;
        return f;
    }

    public static void main(String[] args) throws Exception {
        long startTime = System.currentTimeMillis();
        IndexWiki iw = new IndexWiki();
        iw.index();
        long endTime = System.currentTimeMillis();
        log.info((Object)("::Done indexing in " + (double)(endTime - startTime) / 1000.0 + " sec"));
    }
}

