/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiki;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.Language;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityList {
    private static final Log log = LogFactory.getLog(EntityList.class);
    private static Map<Language, EntityList> singleton = new HashMap<Language, EntityList>();
    private Set<String> entities;
    private Set<String> terms;

    public static synchronized EntityList getInstance(Language language) {
        if (!singleton.containsKey((Object)language)) {
            try {
                singleton.put(language, new EntityList(language));
            }
            catch (IOException ioe) {
                log.info((Object)("Wrong parameters or missing Wikipedia index for language " + language.toString()));
                singleton.put(language, null);
            }
        }
        return singleton.get((Object)language);
    }

    private EntityList(Language language) throws IOException {
        log.info((Object)("LOADING THE WIKIPEDIA ENTITY LIST FOR LANGUAGE " + (Object)((Object)language)));
        this.entities = EntityList.loadFile(Configuration.getInstance().getEntityList(language));
        log.info((Object)"DONE!");
        log.info((Object)("LOADING THE WIKIPEDIA TERM LIST FOR LANGUAGE " + (Object)((Object)language)));
        this.terms = EntityList.loadFile(Configuration.getInstance().getTermList(language));
        log.info((Object)"DONE!");
    }

    private static Set<String> loadFile(String source) throws IOException {
        HashSet<String> list = new HashSet<String>();
        BufferedReader reader = new BufferedReader(new FileReader(source));
        while (reader.ready()) {
            String line = reader.readLine();
            list.add(line);
        }
        return list;
    }

    public boolean isEntity(String page) {
        return this.entities.contains(page);
    }

    public boolean isTerm(String page) {
        return this.terms.contains(page);
    }

    public Set<String> getAllEntities() {
        return this.entities;
    }

    public Set<String> getAllTerms() {
        return this.terms;
    }
}

