/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.web.yahoo;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.web.FileType;
import it.uniroma1.lcl.jlt.web.Proxy;
import it.uniroma1.lcl.jlt.web.Query;
import it.uniroma1.lcl.jlt.web.QueryResult;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class YahooQuery
extends Query {
    private static final Integer MAX_QUERY_RESULTS = 50;

    public YahooQuery(String query) {
        super(query);
    }

    public YahooQuery(String query, int maxQueryResults) {
        super(query);
    }

    @Override
    protected List<QueryResult> getResultsInternal(FileType fileType, Proxy proxy) {
        ArrayList<QueryResult> results = new ArrayList<QueryResult>();
        try {
            Integer resutsNumber = Configuration.getInstance().getYahooResultsNumber();
            int countResults = 0;
            String request = Configuration.getInstance().getYahooSearchUrl();
            String encodedQuery = URLEncoder.encode(this.query, "UTF-8");
            request = String.valueOf(request) + encodedQuery;
            request = String.valueOf(request) + Configuration.getInstance().getYahooSearchUrlAppendix();
            HttpClient client = new HttpClient();
            if (this.bUseProxy) {
                HostConfiguration c = new HostConfiguration();
                c.setProxy(proxy.getHost(), proxy.getPort());
                client.setHostConfiguration(c);
            }
            int numberOfQueries = resutsNumber / MAX_QUERY_RESULTS;
            if (resutsNumber % MAX_QUERY_RESULTS != 0) {
                ++numberOfQueries;
            }
            int j = 0;
            while (j < numberOfQueries) {
                request = String.valueOf(request) + j * MAX_QUERY_RESULTS;
                GetMethod method = new GetMethod(request);
                try {
                    String line;
                    int statusCode = client.executeMethod((HttpMethod)method);
                    if (statusCode != 200) {
                        System.err.println("Method failed: " + method.getStatusLine());
                    }
                    InputStream rstream = method.getResponseBodyAsStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(rstream));
                    String jsonString = "";
                    while ((line = br.readLine()) != null) {
                        jsonString = String.valueOf(jsonString) + line;
                    }
                    br.close();
                    JSONObject jo = JSONObject.fromObject((Object)jsonString.toString()).getJSONObject("ysearchresponse");
                    JSONArray rs = jo.getJSONArray("resultset_web");
                    int i = 0;
                    while (i < rs.size()) {
                        if (countResults < resutsNumber) {
                            JSONObject resultObject = rs.getJSONObject(i);
                            String title = (String)resultObject.get("title");
                            String snippet = (String)resultObject.get("abstract");
                            String url = (String)resultObject.get("url");
                            results.add(new QueryResult(url, title, snippet));
                            ++countResults;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        List<QueryResult> res = new YahooQuery("life").getResults();
        for (QueryResult gr : res) {
            System.out.println(gr.toString());
        }
        System.out.println("Result size = " + res.size());
    }
}

