/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.web.google;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.web.FileType;
import it.uniroma1.lcl.jlt.web.Proxy;
import it.uniroma1.lcl.jlt.web.Query;
import it.uniroma1.lcl.jlt.web.QueryResult;
import it.uniroma1.lcl.jlt.web.google.GoogleSearchMethod;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class GoogleQuery
extends Query {
    protected static final Log log = LogFactory.getLog(GoogleQuery.class);
    private Language targetLanguage = null;

    public GoogleQuery(String query) {
        super(query);
        this.targetLanguage = Language.EN;
    }

    public GoogleQuery(String query, Language targetLanguage) {
        super(query);
        this.targetLanguage = targetLanguage;
    }

    @Override
    protected List<QueryResult> getResultsInternal(FileType fileType, Proxy proxy) {
        GoogleSearchMethod gm = Configuration.getInstance().getGoogleSearchMethod();
        System.out.println("Selected Google Search Method:" + gm.name());
        ArrayList<QueryResult> results = new ArrayList<QueryResult>();
        String query = this.query;
        if (fileType != null) {
            query = String.valueOf(query) + " filetype:" + fileType.toString();
        }
        int start = 0;
        try {
            String encodeQuery = URLEncoder.encode(query, "UTF-8");
            log.info((Object)("ENCODED QUERY:" + encodeQuery));
            while (start < 100) {
                int status;
                URLConnection connection;
                URL queryUrl;
                String ajaxUrl;
                if (gm.equals((Object)GoogleSearchMethod.NO_URP)) {
                    String line;
                    ajaxUrl = String.valueOf(Configuration.getInstance().getFullGoogleAjaxURL(this.targetLanguage)) + encodeQuery;
                    ajaxUrl = ajaxUrl.replace("START", "" + start);
                    queryUrl = new URL(ajaxUrl);
                    connection = null;
                    if (this.bUseProxy) {
                        java.net.Proxy javaProxy = new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getHost(), proxy.getPort()));
                        connection = queryUrl.openConnection(javaProxy);
                        connection.addRequestProperty("Referer", proxy.getHost());
                    } else {
                        connection = queryUrl.openConnection();
                        connection.addRequestProperty("Referer", Configuration.getInstance().getGoogleRequester());
                    }
                    status = ((HttpURLConnection)connection).getResponseCode();
                    log.info((Object)("STATUS:" + status));
                    if (status != 200) break;
                    StringBuilder builder = new StringBuilder();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        builder.append(line);
                    }
                    JSONObject json = JSONObject.fromObject((Object)builder.toString());
                    JSONObject responseData = (JSONObject)json.get("responseData");
                    if (responseData == null || responseData.isNullObject()) break;
                    JSONArray jsonResults = (JSONArray)responseData.get("results");
                    int i = 0;
                    while (i < jsonResults.size()) {
                        JSONObject obj = jsonResults.getJSONObject(i);
                        String url = obj.getString("url");
                        String title = obj.getString("titleNoFormatting");
                        String snippet = obj.getString("content");
                        results.add(new QueryResult(url, title, snippet));
                        ++i;
                    }
                } else {
                    ajaxUrl = String.valueOf(Configuration.getInstance().getURPGoogleSearchURL(this.targetLanguage)) + encodeQuery;
                    ajaxUrl = ajaxUrl.replace("START", "" + start);
                    log.info((Object)("AJAXURL:" + ajaxUrl));
                    queryUrl = new URL(ajaxUrl);
                    connection = null;
                    connection = queryUrl.openConnection();
                    status = ((HttpURLConnection)connection).getResponseCode();
                    log.info((Object)("STATUS:" + status));
                    if (status != 200) break;
                    InputStreamReader in = new InputStreamReader(connection.getInputStream());
                    if (connection == null || in == null) break;
                    BufferedReader br = new BufferedReader(in);
                    String url = "";
                    String title = "";
                    String snippet = "";
                    while (br.ready()) {
                        String line = br.readLine().trim();
                        if (line.startsWith("</R>")) {
                            results.add(new QueryResult(url, title, snippet));
                        }
                        if (line.startsWith("<UE>")) {
                            url = line.replace("<UE>", "").replace("</UE>", "");
                        }
                        if (line.startsWith("<TNB>")) {
                            title = line.replace("<TNB>", "").replace("</TNB>", "");
                        }
                        if (!line.startsWith("<SNB>")) continue;
                        snippet = line.replace("<SNB>", "").replace("</SNB>", "");
                    }
                }
                start = results.size();
                if (start == 0) break;
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws FileNotFoundException, SAXException, IOException, ParserConfigurationException {
        log.info((Object)"TEST");
        System.out.println("TEST");
        List<QueryResult> res = new GoogleQuery("reabsorption is a kind of").getResults();
        for (QueryResult gr : res) {
            System.out.println(gr.toString());
        }
        System.out.println(res.size());
    }
}

