/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.web.google;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.web.FileType;
import it.uniroma1.lcl.jlt.web.Proxy;
import it.uniroma1.lcl.jlt.web.Query;
import it.uniroma1.lcl.jlt.web.QueryResult;
import it.uniroma1.lcl.jlt.web.google.GoogleSearchMethod;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class GoogleCounterQuery
extends Query {
    protected static final Log log = LogFactory.getLog(GoogleCounterQuery.class);
    private Language targetLanguage = null;

    public GoogleCounterQuery(String query) {
        super(query);
        this.targetLanguage = Language.EN;
    }

    public GoogleCounterQuery(String query, Language targetLanguage) {
        super(query);
        this.targetLanguage = targetLanguage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected List<QueryResult> getResultsInternal(FileType fileType, Proxy proxy) {
        GoogleSearchMethod gm = Configuration.getInstance().getGoogleSearchMethod();
        System.out.println("Selected Google Search Method:" + gm.name());
        ArrayList<QueryResult> results = new ArrayList<QueryResult>();
        String query = this.query;
        if (fileType != null) {
            query = String.valueOf(query) + " filetype:" + fileType.toString();
        }
        int start = 0;
        try {
            String encodeQuery = URLEncoder.encode(query, "UTF-8");
            log.info((Object)("ENCODED QUERY:" + encodeQuery));
            if (gm.equals((Object)GoogleSearchMethod.NO_URP)) {
                String line;
                String ajaxUrl = String.valueOf(Configuration.getInstance().getFullGoogleAjaxURL(this.targetLanguage)) + encodeQuery;
                ajaxUrl = ajaxUrl.replace("START", "" + start);
                URL queryUrl = new URL(ajaxUrl);
                URLConnection connection = null;
                if (this.bUseProxy) {
                    java.net.Proxy javaProxy = new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getHost(), proxy.getPort()));
                    connection = queryUrl.openConnection(javaProxy);
                    connection.addRequestProperty("Referer", proxy.getHost());
                } else {
                    connection = queryUrl.openConnection();
                    connection.addRequestProperty("Referer", Configuration.getInstance().getGoogleRequester());
                }
                int status = ((HttpURLConnection)connection).getResponseCode();
                log.info((Object)("STATUS:" + status));
                if (status != 200) {
                    return results;
                }
                StringBuilder builder = new StringBuilder();
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                JSONObject json = JSONObject.fromObject((Object)builder.toString());
                JSONObject responseData = (JSONObject)json.get("responseData");
                if (responseData == null || responseData.isNullObject()) return results;
                JSONObject respobgj = responseData.getJSONObject("cursor");
                Long counter = new Long(respobgj.getString("estimatedResultCount").replaceAll("\"", ""));
                results.add(new QueryResult(counter));
                return results;
            } else {
                String ajaxUrl = String.valueOf(Configuration.getInstance().getURPGoogleSearchURL(this.targetLanguage)) + encodeQuery;
                ajaxUrl = ajaxUrl.replace("START", "" + start);
                log.info((Object)("SEARCH:" + ajaxUrl));
                URL queryUrl = new URL(ajaxUrl);
                URLConnection connection = null;
                connection = queryUrl.openConnection();
                Long counter = null;
                int status = ((HttpURLConnection)connection).getResponseCode();
                log.info((Object)("STATUS:" + status));
                if (status != 200) {
                    return results;
                }
                InputStreamReader in = new InputStreamReader(connection.getInputStream());
                if (connection == null || in == null) {
                    return results;
                }
                BufferedReader br = new BufferedReader(in);
                while (br.ready()) {
                    String line = br.readLine().toLowerCase().trim();
                    if (!line.startsWith("<m>")) continue;
                    counter = new Long(line.replace("<m>", "").replace("</m>", "").trim());
                    results.add(new QueryResult(counter));
                }
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws FileNotFoundException, SAXException, IOException, ParserConfigurationException {
        log.info((Object)"TEST");
        System.out.println("TEST");
        List<QueryResult> res = new GoogleCounterQuery("reabsorption is a kind of").getResults();
        for (QueryResult gr : res) {
            System.out.println(gr.getCounter());
        }
    }
}

