/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.web.google;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.web.QueryResult;
import it.uniroma1.lcl.jlt.web.WebSnippetCache;
import it.uniroma1.lcl.jlt.web.google.GoogleQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GoogleCachedBatchQuery {
    private static final Log log = LogFactory.getLog(GoogleCachedBatchQuery.class);
    private static GoogleCachedBatchQuery instance = null;

    public static GoogleCachedBatchQuery getInstance() {
        if (instance == null) {
            instance = new GoogleCachedBatchQuery();
        }
        return instance;
    }

    private GoogleCachedBatchQuery() {
    }

    public List<String> getResults(Set<String> queries, Language targetLanguage) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        WebSnippetCache wsc = WebSnippetCache.getInstance();
        boolean bQuerySystemEnabled = Configuration.getInstance().getWebQueryEnabled();
        for (String query : queries) {
            List<String> snippets = wsc.getResult(query);
            if (snippets == null) {
                snippets = new ArrayList<String>();
                if (!bQuerySystemEnabled) continue;
                log.debug((Object)("QUERYING GOOGLE FOR: " + query));
                List<QueryResult> res = null;
                GoogleQuery yq = new GoogleQuery(query, targetLanguage);
                res = yq.getResults();
                for (QueryResult gr : res) {
                    String cleanSnippet = gr.getSnippet().replaceAll("<b>", "").replaceAll("</b>", "").toLowerCase();
                    if (snippets.contains(cleanSnippet)) continue;
                    snippets.add(cleanSnippet);
                }
                wsc.putResult(query, snippets);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    System.out.println(ie.getMessage());
                }
            }
            for (String snippet : snippets) {
                if (!snippet.toLowerCase().contains(query.toLowerCase().substring(1, query.length() - 1))) continue;
                result.add(snippet);
            }
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        GoogleCachedBatchQuery gcbq = GoogleCachedBatchQuery.getInstance();
        HashSet<String> queries = new HashSet<String>();
        queries.add("\"monitor is a \"");
        queries.add("\"monitor often refers to \"");
        List<String> results = gcbq.getResults(queries, Language.EN);
        System.out.println(results);
    }
}

