/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.web.google;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.web.QueryResult;
import it.uniroma1.lcl.jlt.web.WebCounterCache;
import it.uniroma1.lcl.jlt.web.google.GoogleCounterQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GoogleCachedBatchCounter {
    private static final Log log = LogFactory.getLog(GoogleCachedBatchCounter.class);
    private static GoogleCachedBatchCounter instance = null;

    public static GoogleCachedBatchCounter getInstance() {
        if (instance == null) {
            instance = new GoogleCachedBatchCounter();
        }
        return instance;
    }

    private GoogleCachedBatchCounter() {
    }

    public List<Long> getResults(Set<String> queries, Language targetLanguage) throws IOException {
        ArrayList<Long> result = new ArrayList<Long>();
        WebCounterCache wsc = WebCounterCache.getInstance();
        boolean bQuerySystemEnabled = Configuration.getInstance().getWebCounterEnabled();
        for (String query : queries) {
            ArrayList<Long> queryresult = new ArrayList<Long>();
            Long count = wsc.getResult(query);
            if (count == null) {
                if (!bQuerySystemEnabled) continue;
                log.debug((Object)("QUERYING GOOGLE FOR: " + query));
                List<QueryResult> res = null;
                GoogleCounterQuery yq = new GoogleCounterQuery(query, targetLanguage);
                res = yq.getResults();
                for (QueryResult qr : res) {
                    queryresult.add(qr.getCounter());
                }
                if (queryresult.size() > 0) {
                    wsc.putResult(query, (Long)queryresult.get(0));
                    result.add((Long)queryresult.get(0));
                } else {
                    wsc.putResult(query, new Long(0L));
                    result.add(new Long(0L));
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    System.out.println(ie.getMessage());
                }
                continue;
            }
            result.add(count);
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        GoogleCachedBatchCounter gcbq = GoogleCachedBatchCounter.getInstance();
        HashSet<String> queries = new HashSet<String>();
        queries.add("monitor");
        List<Long> results = gcbq.getResults(queries, Language.EN);
        System.out.println(results);
    }
}

