/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.web;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WebSnippetCache {
    private static WebSnippetCache instance = null;
    private String webSnippetCache = Configuration.getInstance().getWebSnippetCache();

    public static WebSnippetCache getInstance() {
        if (instance == null) {
            instance = new WebSnippetCache();
        }
        return instance;
    }

    private WebSnippetCache() {
    }

    public List<String> getResult(String query) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        String alphaIndex = this.getAlphabeticIndex(query, 2);
        String cachePath = String.valueOf(this.webSnippetCache) + "/" + alphaIndex + "/";
        File dir = new File(cachePath);
        dir.mkdirs();
        File snippet = new File(String.valueOf(cachePath) + query.replaceAll("/", " "));
        if (snippet.exists()) {
            BufferedReader br = Files.getBufferedReader(String.valueOf(cachePath) + query.replaceAll("/", " "));
            while (br.ready()) {
                result.add(br.readLine());
            }
            br.close();
            return result;
        }
        return null;
    }

    public void putResult(String query, List<String> snippets) throws IOException {
        String alphaIndex = this.getAlphabeticIndex(query, 2);
        String cachePath = String.valueOf(this.webSnippetCache) + "/" + alphaIndex + "/";
        BufferedWriter bw = Files.getBufferedWriter(String.valueOf(cachePath) + query.replaceAll("/", " "));
        for (String s : snippets) {
            bw.write(String.valueOf(s) + "\n");
        }
        bw.close();
    }

    private String getAlphabeticIndex(String query, int len) {
        return query.replaceAll("\"", "").substring(0, len);
    }
}

