/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.web;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;

public class WebCounterCache {
    private static WebCounterCache instance = null;
    private String webCounterCache = Configuration.getInstance().getWebCounterCache();

    public static WebCounterCache getInstance() {
        if (instance == null) {
            instance = new WebCounterCache();
        }
        return instance;
    }

    private WebCounterCache() {
    }

    public Long getResult(String query) throws IOException {
        BufferedReader br;
        Long result = null;
        String alphaIndex = this.getAlphabeticIndex(query, 2);
        String cachePath = String.valueOf(this.webCounterCache) + "/" + alphaIndex + "/";
        File dir = new File(cachePath);
        dir.mkdirs();
        File snippet = new File(String.valueOf(cachePath) + query.replaceAll("/", " "));
        if (snippet.exists() && (br = Files.getBufferedReader(String.valueOf(cachePath) + query.replaceAll("/", " "))).ready()) {
            Long count = new Long(br.readLine());
            br.close();
            return count;
        }
        return result;
    }

    public void putResult(String query, Long result) throws IOException {
        String alphaIndex = this.getAlphabeticIndex(query, 2);
        String cachePath = String.valueOf(this.webCounterCache) + "/" + alphaIndex + "/";
        BufferedWriter bw = Files.getBufferedWriter(String.valueOf(cachePath) + query.replaceAll("/", " "));
        bw.write(result + "\n");
        bw.close();
    }

    private String getAlphabeticIndex(String query, int len) {
        return query.replaceAll("\"", "").substring(0, len);
    }
}

