/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.web;

import it.uniroma1.lcl.jlt.util.Stopwords;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class QueryResult {
    private String url;
    private String title;
    private String snippet;
    private Long counter;

    public QueryResult(String url, String title, String snippet) {
        this.url = url;
        this.title = title;
        this.snippet = snippet;
        this.counter = null;
    }

    public QueryResult(Long counter) {
        this.url = null;
        this.title = null;
        this.snippet = null;
        this.counter = counter;
    }

    public String getURL() {
        return this.url;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSnippet() {
        return this.snippet;
    }

    public Long getCounter() {
        return this.counter;
    }

    public String toString() {
        return "URL: " + this.url + "\nTITLE:" + this.title + "\nSNIPPET:" + this.snippet;
    }

    public List<String> getBOW() {
        Set<String> stems;
        boolean oneCharNotNumb;
        String w;
        ArrayList<String> bowWords = new ArrayList<String>();
        String snippetHTMLCleanWords = this.snippet.replaceAll("\\<.*?>", "");
        String titleHTMLCleanWords = this.title.replaceAll("\\<.*?>", "");
        String[] snippetWords = snippetHTMLCleanWords.toLowerCase().split("[ ,.:;'\"\\(\\)\\?!-]");
        String[] titleWords = titleHTMLCleanWords.toLowerCase().split("[ ,.:;'\"\\(\\)\\?!-]");
        Stopwords sw = Stopwords.getInstance();
        String[] stringArray = snippetWords;
        int n = snippetWords.length;
        int n2 = 0;
        while (n2 < n) {
            w = stringArray[n2];
            oneCharNotNumb = false;
            if (w.length() == 1) {
                try {
                    Integer.parseInt(w);
                }
                catch (NumberFormatException nfe) {
                    oneCharNotNumb = true;
                }
            }
            if (!oneCharNotNumb && !sw.isStopword(w)) {
                stems = WordNet.getInstance().getWordNetStems(w);
                if (stems.isEmpty() || stems.iterator().next() == "") {
                    if (w.compareTo("") != 0) {
                        bowWords.add(w);
                    }
                } else {
                    bowWords.add(stems.iterator().next());
                }
            }
            ++n2;
        }
        stringArray = titleWords;
        n = titleWords.length;
        n2 = 0;
        while (n2 < n) {
            w = stringArray[n2];
            oneCharNotNumb = false;
            if (w.length() == 1) {
                try {
                    Integer.parseInt(w);
                }
                catch (NumberFormatException nfe) {
                    oneCharNotNumb = true;
                }
            }
            if (!oneCharNotNumb && !sw.isStopword(w)) {
                stems = WordNet.getInstance().getWordNetStems(w);
                if (stems.isEmpty() || stems.iterator().next() == "") {
                    if (w.compareTo("") != 0) {
                        bowWords.add(w);
                    }
                } else {
                    bowWords.add(stems.iterator().next());
                }
            }
            ++n2;
        }
        return bowWords;
    }
}

