/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.web;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.threads.TimeControlledQueryThread;
import it.uniroma1.lcl.jlt.web.FileType;
import it.uniroma1.lcl.jlt.web.Proxy;
import it.uniroma1.lcl.jlt.web.ProxyList;
import it.uniroma1.lcl.jlt.web.QueryResult;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Query {
    private static final Log log = LogFactory.getLog(Query.class);
    private static int MAX_ATTEMPTS = 25;
    protected String query;
    public boolean bUseProxy;
    private TimeControlledQueryThread internalThread;

    public Query(String query) {
        this.query = query;
        this.bUseProxy = Configuration.getInstance().useProxy();
    }

    public String getQuery() {
        return this.query;
    }

    public List<QueryResult> getResults() {
        return this.getResults(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueryResult> getResults(final FileType fileType) {
        int attempts = 0;
        List<QueryResult> result = null;
        do {
            if (this.bUseProxy) {
                final Proxy proxy = ProxyList.getInstance().getNextRandomProxy();
                try {
                    long start = System.currentTimeMillis();
                    this.internalThread = new TimeControlledQueryThread(result, 10000L){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            this.timeOutThread.start();
                            log.info((Object)"Starting...");
                            try {
                                this.result = Query.this.getResultsInternal(fileType, proxy);
                                this.everythingDone = true;
                            }
                            catch (Throwable throwable) {
                                log.info((Object)"Killing...");
                                this.timeOutThread.kill();
                                this.isRunning = false;
                                1 var2_2 = this;
                                synchronized (var2_2) {
                                    this.notifyAll();
                                }
                                log.info((Object)"Killed");
                                throw throwable;
                            }
                            log.info((Object)"Killing...");
                            this.timeOutThread.kill();
                            this.isRunning = false;
                            1 var2_3 = this;
                            synchronized (var2_3) {
                                this.notifyAll();
                            }
                            log.info((Object)"Killed");
                        }
                    };
                    this.internalThread.start();
                    try {
                        while (this.internalThread.isRunning) {
                            TimeControlledQueryThread timeControlledQueryThread = this.internalThread;
                            synchronized (timeControlledQueryThread) {
                                this.internalThread.wait(1000L);
                            }
                        }
                        long stop = System.currentTimeMillis();
                        if (this.internalThread.everythingDone) {
                            log.info((Object)("all done in " + (stop - start) + " ms."));
                            result = this.internalThread.getResults();
                            continue;
                        }
                        log.info((Object)("could not do everything in " + (stop - start) + " ms."));
                        if (this.internalThread.endedWithException == null) continue;
                        this.internalThread.endedWithException.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        log.info((Object)"You've killed me!");
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("Could not query \"" + this.query + "\" exception: " + e));
                    if (proxy == null) continue;
                    log.warn((Object)("EXCEPTION:" + e));
                    log.warn((Object)("BAD PROXY? = " + proxy.toString() + ", current size: " + ProxyList.getInstance().size()));
                    log.warn((Object)("ATTEMPT: " + attempts));
                    ProxyList.getInstance().remove(proxy);
                    ++attempts;
                }
                continue;
            }
            result = this.getResultsInternal(fileType, null);
        } while (result == null && attempts < MAX_ATTEMPTS);
        return result;
    }

    protected abstract List<QueryResult> getResultsInternal(FileType var1, Proxy var2);
}

