/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.web;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.web.Proxy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxyList {
    private static final Log log = LogFactory.getLog(ProxyList.class);
    private static ProxyList instance = null;
    private List<Proxy> proxyList = null;
    private int lastChoice = -1;

    public static ProxyList getInstance() {
        if (instance == null) {
            instance = new ProxyList();
        }
        return instance;
    }

    private ProxyList() {
        this.reload();
    }

    public Proxy getNextRandomProxy() {
        int choice;
        if (this.size() < 20) {
            log.info((Object)"Proxy list size < 20: reloading");
            this.reload();
        }
        while ((choice = (int)(Math.random() * (double)this.proxyList.size())) == this.lastChoice) {
        }
        this.lastChoice = choice;
        return this.proxyList.get(choice);
    }

    public void remove(Proxy proxy) {
        this.proxyList.remove(proxy);
    }

    public int size() {
        return this.proxyList.size();
    }

    public void reload() {
        String proxyListDir = Configuration.getInstance().getProxyDirectory();
        File file = new File(proxyListDir);
        this.proxyList = new ArrayList<Proxy>();
        try {
            String line = null;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                line = line.trim();
                String[] proxy = line.split(":");
                String host = proxy[0];
                int port = Integer.valueOf(proxy[1]);
                this.proxyList.add(new Proxy(host, port));
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

