/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Timer {
    protected static final Log log = LogFactory.getLog(Timer.class);
    private long initialStartTime;
    private long lastStartTime;

    public Timer() {
        this.setStartTime();
    }

    public void setStartTime() {
        this.initialStartTime = System.currentTimeMillis();
        this.lastStartTime = System.currentTimeMillis();
    }

    public long getTime(String str) {
        StringBuffer buffer = new StringBuffer();
        long elapsed = System.currentTimeMillis() - this.initialStartTime;
        buffer.append("Time elapsed to ").append(str).append(": ").append(elapsed).append(" ms").toString();
        log.info((Object)buffer);
        return elapsed;
    }

    public long getTime() {
        return System.currentTimeMillis() - this.initialStartTime;
    }

    public long tick(String str) {
        StringBuffer buffer = new StringBuffer();
        long time2 = System.currentTimeMillis();
        long elapsed = time2 - this.lastStartTime;
        this.lastStartTime = time2;
        buffer.append("Time elapsed ").append(str).append(": ").append(elapsed).append(" ms").toString();
        log.info((Object)buffer);
        return elapsed;
    }

    public long tick() {
        long time2 = System.currentTimeMillis();
        long elapsed = time2 - this.lastStartTime;
        this.lastStartTime = time2;
        return elapsed;
    }

    public String getTimeInString() {
        return Timer.getTimeFromMilliseconds(this.tick());
    }

    public String getElapsedTimeInString() {
        return Timer.getTimeFromMilliseconds(this.getTime());
    }

    public static long getTimeInMilliseconds(String time) {
        long milliseconds = 0L;
        time = time.replaceAll(":| ", "");
        time = time.toLowerCase();
        String REGEX = "(.*)h(.*)m(.*)s";
        Pattern p = Pattern.compile(REGEX);
        Matcher m = p.matcher(time);
        m.find();
        int hours = new Integer(m.group(1));
        int minutes = new Integer(m.group(2));
        int seconds = new Integer(m.group(3));
        milliseconds = 1000 * (hours * 3600 + minutes * 60 + seconds);
        return milliseconds;
    }

    public static String getTimeFromMilliseconds(long ms) {
        int elapsedHours = (int)((double)ms / 3600000.0);
        int elapsedMinutes = (int)((double)(ms - (long)(3600000 * elapsedHours)) / 60000.0);
        int elapsedSeconds = (int)((double)(ms - (long)(3600000 * elapsedHours) - (long)(60000 * elapsedMinutes)) / 1000.0);
        return String.valueOf(elapsedHours) + "h : " + elapsedMinutes + "m : " + elapsedSeconds + "s";
    }
}

