/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import com.google.common.collect.Lists;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.IntegerCounter;
import it.uniroma1.lcl.jlt.util.MapCounter;
import it.uniroma1.lcl.jlt.util.Maths;
import it.uniroma1.lcl.jlt.util.ScoredItem;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TfIdf<D extends Iterable<W>, W> {
    private static final String NDOCS_SUFFIX = "-ndocs.txt";
    private static final String TF_SUFFIX = "-tf.txt";
    private static final String IDF_SUFFIX = "-idf.txt";
    private final MapCounter<String, W> tfCounter;
    private final IntegerCounter<W> idfCounter;
    private int nDocs;

    public TfIdf() {
        this.tfCounter = new MapCounter();
        this.idfCounter = new IntegerCounter();
    }

    private TfIdf(MapCounter<String, W> tfCounter, IntegerCounter<W> idfCounter, int nDocs) {
        this.tfCounter = tfCounter;
        this.idfCounter = idfCounter;
        this.nDocs = nDocs;
    }

    public void addDocument(D document, String documentId) {
        if (this.tfCounter.keySet().contains(documentId)) {
            return;
        }
        ++this.nDocs;
        HashSet done = new HashSet();
        for (Object word : document) {
            this.tfCounter.count(documentId, word);
            if (done.contains(word)) continue;
            done.add(word);
            this.idfCounter.count(word);
        }
    }

    public int getTf(String doc, W w) {
        return this.tfCounter.get(doc, w);
    }

    public double getIdf(W w) {
        double idf = ((Integer)this.idfCounter.get(w)).intValue();
        if (idf == 0.0) {
            return 0.0;
        }
        return Maths.log2((double)this.nDocs / idf);
    }

    public int getNumberOfDocument(W w) {
        return (Integer)this.idfCounter.get(w);
    }

    public Set<W> getAllTerms() {
        return this.idfCounter.keySet();
    }

    public Set<W> getAllDocumentTerms(String doc) {
        return this.tfCounter.get(doc).keySet();
    }

    public Set<String> getAllDocumentIds() {
        return this.tfCounter.keySet();
    }

    public double getTfIdf(String doc, W w) {
        int tf = this.getTf(doc, w);
        double idf = this.getIdf(w);
        return (double)tf * idf;
    }

    public Set<ScoredItem<W>> getScoredDocumentTerms(String doc) {
        HashSet<ScoredItem<W>> scoredTerms = new HashSet<ScoredItem<W>>();
        for (W w : this.getAllDocumentTerms(doc)) {
            scoredTerms.add(new ScoredItem<W>(w, this.getTfIdf(doc, w)));
        }
        return scoredTerms;
    }

    public void reset() {
        this.nDocs = 0;
        this.idfCounter.clear();
        this.tfCounter.resetCounts();
    }

    public void saveToFile(String prefix) throws IOException {
        File dad = new File(prefix).getParentFile();
        if (dad != null && !dad.exists()) {
            dad.mkdirs();
        }
        FileWriter nDocsWriter = new FileWriter(String.valueOf(prefix) + NDOCS_SUFFIX);
        nDocsWriter.write(new Integer(this.nDocs).toString());
        nDocsWriter.close();
        this.tfCounter.saveToFile(String.valueOf(prefix) + TF_SUFFIX);
        this.idfCounter.saveToFile(String.valueOf(prefix) + IDF_SUFFIX);
    }

    public void appendToFile(String prefix) throws IOException {
        File dad = new File(prefix).getParentFile();
        if (dad != null && !dad.exists()) {
            dad.mkdirs();
        }
        Files.writeOneLinePerDataItem(Lists.newArrayList((Object[])new Integer[]{new Integer(this.nDocs)}), String.valueOf(prefix) + NDOCS_SUFFIX, true);
        this.tfCounter.saveToFile(String.valueOf(prefix) + TF_SUFFIX, true, false, String.CASE_INSENSITIVE_ORDER);
        this.idfCounter.saveToFile(String.valueOf(prefix) + IDF_SUFFIX, false, true);
    }

    public static TfIdf<Collection<String>, String> loadFromFile(String prefix) throws IOException {
        List<String> nDocsList = Files.readOneLinePerDataItem(String.valueOf(prefix) + NDOCS_SUFFIX);
        int nDocs = 0;
        for (String nDoc : nDocsList) {
            nDocs += Integer.parseInt(nDoc);
        }
        MapCounter<String, String> tfCounter = MapCounter.loadFromFile(String.valueOf(prefix) + TF_SUFFIX);
        IntegerCounter<String> idfCounter = IntegerCounter.loadFromFile(String.valueOf(prefix) + IDF_SUFFIX);
        TfIdf<Collection<String>, String> tfIdf = new TfIdf<Collection<String>, String>(tfCounter, idfCounter, nDocs);
        return tfIdf;
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        try {
            ArrayList<ArrayList> documents = new ArrayList<ArrayList>();
            documents.add(Lists.newArrayList((Object[])new String[]{"A", "B", "C", "D", "E", "E", "E"}));
            documents.add(Lists.newArrayList((Object[])new String[]{"A", "B"}));
            documents.add(Lists.newArrayList((Object[])new String[]{"A", "B", "C"}));
            documents.add(Lists.newArrayList((Object[])new String[]{"E", "E", "E"}));
            documents.add(Lists.newArrayList((Object[])new String[]{"A", "B", "E"}));
            for (List list : documents) {
                System.out.println(list);
            }
            boolean bl = false;
            TfIdf<List, String> tfidf = new TfIdf<List, String>();
            for (List list : documents) {
                void var2_6;
                tfidf.addDocument(list, "" + (int)(++var2_6));
            }
            tfidf.saveToFile("test-TFIDF");
            for (String string : tfidf.getAllTerms()) {
                int n = 0;
                while (n < documents.size()) {
                    System.out.println("=== " + string + "/Doc" + n + " ===");
                    System.out.println("\tTF:" + tfidf.getTf("" + n, string));
                    System.out.println("\tIDF:" + tfidf.getTfIdf("" + n, string));
                    System.out.println("\tNumber of Documents:" + tfidf.getNumberOfDocument(string));
                    ++n;
                }
            }
            TfIdf<Collection<String>, String> tfIdf = TfIdf.loadFromFile("test-TFIDF");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

