/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.uniroma1.lcl.jlt.util.Pair;
import it.uniroma1.lcl.jlt.util.Strings;
import java.util.Collection;
import java.util.List;

public class Tag {
    private String name;
    protected Multimap<String, String> attributes;
    private String text = "";

    public Tag(String name) {
        this(name, "");
    }

    public Tag(String name, String attributeString) {
        this.name = name;
        this.attributes = new HashMultimap();
        if (attributeString != null && !attributeString.isEmpty()) {
            attributeString = attributeString.replaceAll(" +", " ").replaceAll(" *= *", "=");
            List<String> pairs = Strings.split(attributeString, " ");
            for (String pair : pairs) {
                Pair<String, String> p = Strings.splitToPair(pair, "=");
                String value = p.getSecond().trim();
                if (value.startsWith("'") || value.startsWith("\"")) {
                    value = value.substring(1);
                }
                if (value.endsWith("'") || value.endsWith("\"")) {
                    value = Strings.substring(value, 0, -1);
                }
                this.attributes.put((Object)p.getFirst().trim(), (Object)value);
            }
        }
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getAttributeValue(String name) {
        return this.attributes.get((Object)name);
    }

    public String toString() {
        return "NAME = " + this.name + ", ATTRIBUTES = " + this.attributes.toString() + ", TEXT = " + this.text;
    }

    public static void main(String[] args) {
        Tag t = new Tag("pippo", "a=\"ciao\"   b =  \"hello\" c =    \"h\" a    =\"ciao2\"");
        System.out.println(t.toString());
    }
}

