/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.SuffixTreeEdge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class SuffixTreeNode {
    SuffixTreeEdge incomingEdge = null;
    int nodeDepth = -1;
    int label = -1;
    Collection<SuffixTreeNode> children = null;
    SuffixTreeNode parent = null;
    int stringDepth;
    int id = 0;
    public static int c;
    List<String> texts = new ArrayList<String>();

    public SuffixTreeNode(SuffixTreeNode parent, String incomingLabel, int depth, int label, int id) {
        this.children = new ArrayList<SuffixTreeNode>();
        this.incomingEdge = new SuffixTreeEdge(incomingLabel, label);
        this.nodeDepth = depth;
        this.label = label;
        this.parent = parent;
        this.stringDepth = parent.stringDepth + incomingLabel.length();
        this.id = id;
    }

    public SuffixTreeNode() {
        this.children = new ArrayList<SuffixTreeNode>();
        this.nodeDepth = 0;
        this.label = 0;
    }

    public void addSuffix(List<String> suffix, int pathIndex, String fullText) {
        SuffixTreeNode insertAt = this;
        insertAt = this.search(this, suffix, fullText);
        this.insert(insertAt, suffix, pathIndex, fullText);
    }

    private SuffixTreeNode search(SuffixTreeNode startNode, List<String> suffix, String fullText) {
        if (suffix.size() == 0) {
            throw new IllegalArgumentException("Empty suffix. Probably no valid simple suffix tree exists for the input.");
        }
        Collection<SuffixTreeNode> children = startNode.children;
        for (SuffixTreeNode child : children) {
            if (!child.incomingEdge.label.equals(suffix.get(0))) continue;
            suffix.remove(0);
            child.texts.add(fullText);
            if (suffix.isEmpty()) {
                return child;
            }
            return this.search(child, suffix, fullText);
        }
        return startNode;
    }

    private void insert(SuffixTreeNode insertAt, List<String> suffix, int pathIndex, String fullText) {
        SuffixTreeNode child = null;
        int j = 0;
        while (j < suffix.size()) {
            child = new SuffixTreeNode(insertAt, String.valueOf(suffix.get(j)), insertAt.nodeDepth + 1, pathIndex, this.id);
            insertAt.children.add(child);
            child.texts.add(fullText);
            insertAt = child;
            ++j;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        String incomingLabel = this.isRoot() ? "" : this.incomingEdge.label;
        int i = 1;
        while (i <= this.nodeDepth) {
            result.append("\t");
            ++i;
        }
        if (this.isRoot()) {
            c = 1;
            this.id = 1;
        } else {
            this.id = c;
            result.append(String.valueOf(this.parent.id) + " -> ");
            result.append(String.valueOf(this.id) + " [label=\"" + incomingLabel.replaceAll("\"", "\\\\\"") + "; " + this.texts.toString() + "\"];\n");
        }
        for (SuffixTreeNode child : this.children) {
            child.parent.id = this.id;
            child.id = ++c;
            result.append(child.toString());
        }
        return result.toString();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }
}

