/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import edu.mit.jwi.item.POS;
import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.util.Maths;
import it.uniroma1.lcl.jlt.util.Pair;
import it.uniroma1.lcl.jlt.util.Sets;
import it.uniroma1.lcl.jlt.util.Triple;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Strings {
    private static final int DEFAULT_PAD = 15;
    private static final String STRING_SEPARATOR = " ";
    private static final Pattern PUNCTUATION = Pattern.compile(".*\\p{Punct}.*");
    private static final String SENSE_SEPARATOR = "#";
    private static final NumberFormat defaultNumberFormat = DecimalFormat.getInstance(Locale.UK);
    private static final int DEFAULT_FRACTION_DIGITS = 5;

    static {
        defaultNumberFormat.setMinimumFractionDigits(5);
        defaultNumberFormat.setMaximumFractionDigits(5);
    }

    public static String toPaddedString(Object obj) {
        return Strings.toPaddedString(obj, 15);
    }

    public static String toPaddedString(Object obj, int padding) {
        if (obj.toString().length() >= padding) {
            return obj.toString().substring(0, padding);
        }
        StringBuffer buffer = new StringBuffer();
        int pad = obj.toString().length();
        while (pad++ < padding) {
            buffer.append(STRING_SEPARATOR);
        }
        buffer.append(obj.toString());
        return buffer.toString();
    }

    public static String decorate(List<String> things) {
        return Strings.decorate('=', 3, things);
    }

    public static String decorate(String ... things) {
        return Strings.decorate('=', things);
    }

    public static String decorate(char decoration, String ... things) {
        return Strings.decorate(decoration, 3, things);
    }

    public static String decorate(char decoration, int extrapad, String ... things) {
        return Strings.decorate(decoration, extrapad, Arrays.asList(things));
    }

    public static String decorate(char decoration, int extrapad, List<String> things) {
        StringBuffer decorated = new StringBuffer();
        int max = Integer.MIN_VALUE;
        for (String thing : things) {
            max = Math.max(max, thing.length() + 2);
        }
        decorated.append(String.valueOf(Strings.getNTimes(decoration, 2 * extrapad + max)) + "\n");
        for (String thing : things) {
            if (thing.isEmpty()) {
                decorated.append(String.valueOf(Strings.getNTimes(decoration, 2 * extrapad + max)) + "\n");
                continue;
            }
            int pad = (max - (thing.length() + 2)) / 2;
            decorated.append(String.valueOf(Strings.getNTimes(decoration, extrapad + pad)) + STRING_SEPARATOR + thing + STRING_SEPARATOR + Strings.getNTimes(decoration, extrapad + pad) + "\n");
        }
        decorated.append(Strings.getNTimes(decoration, 2 * extrapad + max));
        return decorated.toString();
    }

    public static Set<String> getSetFromString(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("^\\[", "").replaceAll("\\]$", "").replaceAll(", ", ",");
        return Sets.varargsToHashSet(s.split(","));
    }

    public static String getNTimes(char c, int times) {
        int timesSoFar = 0;
        StringBuffer buffer = new StringBuffer();
        while (timesSoFar++ < times) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static int getMaxStringLength(Iterable<? extends Object> coll) {
        int max = 0;
        for (Object object : coll) {
            int length = object.toString().length();
            if (length <= max) continue;
            max = length;
        }
        return max;
    }

    public static String join(Iterable<? extends Object> args, String joint) {
        StringBuffer sb = new StringBuffer();
        for (Object object : args) {
            String s = object.toString();
            if (s.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(joint);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String join(Iterable<? extends Object> args) {
        return Strings.join(args, STRING_SEPARATOR);
    }

    public static String join(String[] args) {
        return Strings.join(Arrays.asList(args), STRING_SEPARATOR);
    }

    public static String join(String[] args, String joint) {
        return Strings.join(Arrays.asList(args), joint);
    }

    public static String join(String[] args, int startIdx, int endIdx, String joint) {
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < args.length) {
            String s;
            if (k >= startIdx && k <= endIdx && !(s = args[k]).isEmpty()) {
                if (sb.length() > 0) {
                    sb.append(joint);
                }
                sb.append(s);
            }
            ++k;
        }
        return sb.toString();
    }

    public static List<String> split(String s) {
        return Strings.split(s, STRING_SEPARATOR);
    }

    public static List<String> split(String s, String joint) {
        return Arrays.asList(s.split(joint));
    }

    public static List<String> split(String s, String[] joints) {
        ArrayList<String> l = new ArrayList<String>();
        int j = 0;
        int k = 0;
        while (j < s.length()) {
            int idx = s.indexOf(joints[k], j);
            if (idx == -1) {
                l.add(s.substring(j));
                break;
            }
            l.add(s.substring(j, idx));
            j = idx + joints[k].length();
            if (k >= joints.length - 1) continue;
            ++k;
        }
        return l;
    }

    public static Pair<String, String> splitToPair(String s, String separator) {
        String first = Strings.prefixUntil(s, separator);
        String second = s.substring(first.length() + separator.length());
        return new Pair<String, String>(first, second);
    }

    public static Pair<String, String> splitToPair(String s) {
        return Strings.splitToPair(s, STRING_SEPARATOR);
    }

    public static Pair<String, String> splitToPairWithLastIndex(String s, String separator) {
        int lastIndex = s.lastIndexOf(separator);
        String first = s.substring(0, lastIndex);
        String second = s.substring(lastIndex + 1);
        return new Pair<String, String>(first, second);
    }

    public static Triple<String, String, String> splitToTriple(String s, String separator) {
        String first = Strings.prefixUntil(s, separator);
        s = s.substring(first.length() + separator.length());
        String second = Strings.prefixUntil(s, separator);
        String third = s.substring(second.length() + separator.length());
        return new Triple<String, String, String>(first, second, third);
    }

    public static Triple<String, String, String> splitToTriple(String s) {
        return Strings.splitToTriple(s, STRING_SEPARATOR);
    }

    public static Collection<Integer> getPositions(String s, char c) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        int k = 0;
        while (k < s.length()) {
            if (s.charAt(k) == c) {
                l.add(k);
            }
            ++k;
        }
        return l;
    }

    public static int count(String s, char c) {
        int count = 0;
        int k = 0;
        while (k < s.length()) {
            if (s.charAt(k) == c) {
                ++count;
            }
            ++k;
        }
        return count;
    }

    public static String flipCompound(String term) {
        String[] elems = term.split("_");
        if (elems.length == 2) {
            return String.valueOf(elems[1]) + "_" + elems[0];
        }
        return term;
    }

    public static Collection<String> getAllSubstrings(String s) {
        String[] terms = s.split("[_ ]");
        HashSet<String> substrings = new HashSet<String>();
        int k = 0;
        while (k < terms.length) {
            int j = k;
            while (j < terms.length) {
                substrings.add(Strings.join(terms, k, j, "_"));
                ++j;
            }
            ++k;
        }
        return substrings;
    }

    public static boolean isUpperCase(String s) {
        int i = 0;
        while (i < s.length()) {
            if (Character.isLowerCase(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isLowerCase(String s) {
        int i = 0;
        while (i < s.length()) {
            if (Character.isUpperCase(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static List<String> toLowerCase(Collection<String> collection) {
        ArrayList<String> lowerCased = new ArrayList<String>();
        for (String s : collection) {
            lowerCased.add(s.toLowerCase());
        }
        return lowerCased;
    }

    public static String forceFirstCharUppercase(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(Character.toUpperCase(s.charAt(0)));
            buffer.append(s.substring(1));
            return buffer.toString();
        }
        return s;
    }

    public static boolean containsDigits(String s) {
        int i = 0;
        while (i < s.length()) {
            if (Character.isDigit(s.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsLetter(String s) {
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isLetter(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean containsPunctuation(String s) {
        return PUNCTUATION.matcher(s).matches();
    }

    public static String trimPunctuation(String s) {
        return s.replaceAll("\\p{Punct}+$", "").replaceAll("^\\p{Punct}+", "");
    }

    public static String trimPunctuationAndSpace(String s) {
        return s.replaceAll(" *\\p{Punct}+ *$", "").replaceAll("^ *\\p{Punct}+ *", "");
    }

    public static String lastCharOf(String s) {
        return Strings.suffixOf(s, 1);
    }

    public static String prefixOf(String s, int len) {
        if (s.length() < len) {
            return s;
        }
        return s.substring(0, len);
    }

    public static String prefixUntil(String s, char cue) {
        return Strings.prefixUntil(s, String.valueOf(cue));
    }

    public static String prefixUntil(String s, String cue) {
        int idx = s.indexOf(cue);
        if (idx == -1) {
            return s;
        }
        return s.substring(0, idx);
    }

    public static String prefixUntilLast(String s, char cue) {
        return Strings.prefixUntilLast(s, String.valueOf(cue));
    }

    public static String prefixUntilLast(String s, String cue) {
        int idx = s.lastIndexOf(cue);
        if (idx == -1) {
            return s;
        }
        return s.substring(0, idx);
    }

    public static String removeTrailing(String s, char c) {
        String REGEX = "(" + c + "*).*";
        Pattern p = Pattern.compile(REGEX);
        Matcher m = p.matcher(s);
        String trimmed = s;
        if (!m.find()) {
            return trimmed;
        }
        return trimmed.substring(m.group(1).length());
    }

    public static String suffixOf(String s, int len) {
        if (s.length() - len < 0) {
            return s;
        }
        return s.substring(s.length() - len);
    }

    public static String suffixUntil(String s, char cue) {
        return Strings.suffixUntil(s, String.valueOf(cue));
    }

    public static String suffixUntil(String s, String cue) {
        int idx = s.lastIndexOf(cue);
        if (idx == -1) {
            return s;
        }
        return s.substring(idx += cue.length());
    }

    public static String leftFillWith(String s, char c, int i) {
        StringBuffer sb = new StringBuffer();
        int k = i - s.length();
        while (k > 0) {
            sb.append(c);
            --k;
        }
        sb.append(s);
        return sb.toString();
    }

    public static String rightFillWith(String s, char c, int i) {
        StringBuffer sb = new StringBuffer();
        sb.append(s);
        int k = i - s.length();
        while (k > 0) {
            sb.append(c);
            --k;
        }
        return sb.toString();
    }

    public static boolean isAlphaNum(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    public static boolean isAlphaNum(String s) {
        boolean bIsAlphaNum = false;
        int i = 0;
        while (i < s.length()) {
            if (Strings.isAlphaNum(s.charAt(i))) {
                bIsAlphaNum = true;
                break;
            }
            ++i;
        }
        return bIsAlphaNum;
    }

    public static boolean isInteger(String s) {
        Integer integer = null;
        try {
            integer = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return integer != null;
    }

    public static char charAt(String s, int i) {
        if (i >= 0) {
            return s.charAt(i);
        }
        return s.charAt(s.length() - i);
    }

    public static boolean isVowel(char c) {
        switch (c) {
            case 'A': 
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': 
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return true;
            }
        }
        return false;
    }

    public static boolean isConsonant(char c) {
        switch (c) {
            case 'A': 
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': 
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return false;
            }
        }
        return Character.isLetter(c);
    }

    public static String substring(String s, int i, int j) {
        if (j >= 0) {
            return s.substring(i, j);
        }
        return s.substring(i, s.length() + j);
    }

    public static String getTimestamp() {
        Date now = new Date();
        return new SimpleDateFormat("yyyyMMdd-HH:mm:ss:SSS").format(now);
    }

    public static boolean containsIgnoreCase(Collection<String> collection, String s) {
        for (String c : collection) {
            if (!c.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOneOf(String s, Collection<String> collection) {
        for (String c : collection) {
            if (!s.contains(c)) continue;
            return true;
        }
        return false;
    }

    public static String format(Number n, Locale locale, int minFractionDigits, int maxFractionDigits) {
        NumberFormat nf = DecimalFormat.getInstance(locale);
        nf.setMaximumFractionDigits(maxFractionDigits);
        nf.setMinimumFractionDigits(minFractionDigits);
        return nf.format(n);
    }

    public static String format(Number n) {
        return defaultNumberFormat.format(n);
    }

    public static String format(Number n, Locale locale) {
        NumberFormat nf = DecimalFormat.getInstance(locale);
        nf.setMaximumFractionDigits(5);
        nf.setMinimumFractionDigits(5);
        return defaultNumberFormat.format(n);
    }

    public static String getPercentage(Number n, Number m) {
        return String.valueOf(Strings.format(Maths.getPercentage(n, m))) + "%";
    }

    public static Multimap<Language, String> parseLanguageParameterValues(String parameterValue) {
        HashMultimap map = new HashMultimap();
        if ((parameterValue = parameterValue.trim()).isEmpty()) {
            return map;
        }
        String[] parameterValueSplit = parameterValue.split(",");
        Language actualLang = null;
        String[] stringArray = parameterValueSplit;
        int n = parameterValueSplit.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            try {
                actualLang = Language.valueOf(value.trim());
            }
            catch (IllegalArgumentException e) {
                if (actualLang != null) {
                    map.put((Object)actualLang, (Object)value.trim());
                }
                throw new RuntimeException("Invalid multilingual list of parameter values: " + parameterValue);
            }
            ++n2;
        }
        return map;
    }

    public static boolean isEnglishArticle(String s) {
        String st = s.trim();
        return st.equalsIgnoreCase("the") || st.equalsIgnoreCase("a") || st.equalsIgnoreCase("an");
    }

    public static String getLemma(String word) {
        return Strings.prefixUntil(word, SENSE_SEPARATOR);
    }

    public static POS getPos(String word) {
        int count = Strings.count(word, SENSE_SEPARATOR.charAt(0));
        if (count <= 0) {
            return null;
        }
        if (count == 1 && !word.matches("[^#]+#[^#]+")) {
            return null;
        }
        if (count > 1 && !word.matches("[^#]+#[^#]+#.+")) {
            return null;
        }
        return POS.getPartOfSpeech((char)Strings.splitToPair(word, SENSE_SEPARATOR).getSecond().charAt(0));
    }

    public static char getPosChar(String word) {
        return Strings.splitToPair(word, SENSE_SEPARATOR).getSecond().charAt(0);
    }

    public static String getLemmaPos(String word) {
        return String.valueOf(Strings.getLemma(word)) + SENSE_SEPARATOR + Strings.getPosChar(word);
    }

    public static String getSense(String word) {
        String[] pieces = word.split(SENSE_SEPARATOR);
        if (pieces.length < 3) {
            return null;
        }
        return pieces[2];
    }

    public static ArrayList<String> getLemmaPos(Collection<String> senseList) {
        ArrayList<String> lemmaposes = new ArrayList<String>();
        for (String sense : senseList) {
            lemmaposes.add(String.valueOf(Strings.getLemma(sense)) + SENSE_SEPARATOR + Strings.getPosChar(sense));
        }
        return lemmaposes;
    }

    public static String getMemoryUsed() {
        return Strings.convertToKiloFormat(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
    }

    public static long convertFromKiloFormat(String kiloString) {
        long quantity = 0L;
        kiloString = kiloString.replace(STRING_SEPARATOR, "");
        kiloString = kiloString.toUpperCase();
        String regexp = "(\\d*)([KMG]*)";
        Pattern p = Pattern.compile(regexp);
        Matcher m = p.matcher(kiloString);
        m.find();
        quantity = new Long(m.group(1));
        String base = m.group(2);
        if (base != null) {
            if (base.equals("K")) {
                quantity *= 1000L;
            } else if (base.equals("M")) {
                quantity *= 1000000L;
            } else if (base.equals("G")) {
                quantity *= 1000000000L;
            }
        }
        return quantity;
    }

    public static String convertToKiloFormat(long number) {
        int times = 0;
        double digits = number;
        while (digits >= 1000.0) {
            digits /= 1000.0;
            ++times;
        }
        String base = "";
        switch (times) {
            case 0: {
                base = "";
                break;
            }
            case 1: {
                base = "K";
                break;
            }
            case 2: {
                base = "M";
                break;
            }
            case 3: {
                base = "G";
                break;
            }
        }
        return String.valueOf(NumberFormat.getInstance().format(digits)) + STRING_SEPARATOR + base;
    }

    public static String deAccent(String s) {
        String nfdNormalizedString = Normalizer.normalize(s, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(nfdNormalizedString).replaceAll("");
    }

    public static List<String> toString(Collection<?> objects) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Object o : objects) {
            strings.add(o.toString());
        }
        return strings;
    }

    public static void main(String[] args) {
        System.out.println(Strings.splitToPair("a\tb\tc", "\t"));
        System.out.println(Strings.splitToTriple("a\tb\tc\td", "\t"));
        System.out.println(Strings.trimPunctuationAndSpace(" , attenzione alla: "));
        System.out.println(Strings.trimPunctuation(" , attenzione alla: "));
        System.out.println(Strings.containsPunctuation("I love oranges!"));
        System.out.println(Strings.deAccent("ni\u00f1a tensi\u00f3n misi\u00f3n ejecuci\u00f3n"));
        System.out.println(Strings.join(new String[]{"a", "b", "c"}));
        System.out.println(Strings.getAllSubstrings("a_b_c_d"));
        System.out.println(Strings.getSetFromString("[president, cover-up, shipment, chance, party, syndicate, bribery, story, deputy, florida, latin_america, government, asset, portfolio, evans, leading_indicator, project, european, opening, prime_minister, view, review, computer, flyer, arab, oil, currency, ed, stake, wage, hermann, logistics, italy, school_board, treasury_note, shortage, hungary, dixie, violence, debt, firm, geneva, call_option, gain, brazil, red, testing, red_cross, public, client, drop, lead, morocco, capital, fate, obligation, polk, software, conduct, gilt, deal, commons, reputation, bank, yielding, station, outlook, german, sale, holiday, sign, newman, platinum, lease, economics, suggestion, treasury, pound, debenture, indicator, measure, vice, hedge_fund, employer, insider, dealing, disparity, understanding, purchase, business, island, argentina, response, organization, area, circulation, employee, coupon, talk, ba, san_antonio, guinea-bissau, suspension, departure, al, capital_gain, source, mission, royal, meeting, arrival, venture, order_book, market_place, growth, employment, manager, lobby, yield, reason, concern, thailand, joyce, reporter, operation, weekend, report, carrier, import, central, limit, orientation, ron, point_of_view, recommendation, board, south_african, committee, county, scene, branch, labourer, delivery, comment, newspaper, expert, region, accident, hardware, europe, egyptian, shawn, development, mandate, crew, constraint, workplace, datum, plea, leon, dollar, construction, situation, note, conservative_party, star, nairobi, luxembourg, flight, plane, flashpoint, finance, bloodmobile, telephone, closing, corporate_bond, equity, underwriter, imf, internationale, shipping, level, hit, operating_budget, participation, gulf, toga, credit, flexibility, eye, analyst, joint, minus, contract, emirate, offering, team, central_bank, statement, exodus, winter, owner, bourse, acting, fulton, foreign_exchange, loss, investor, revenue_bond, dome, way, security, investment, risk, staff, japan, rate, rise, purchasing, banking, stevens, vacuum, revenue, peer, building, balanced_budget, agreement, resource, problem, general_manager, instrument, picket_line, election, easter, opportunity, plan, cairo, implementation, warburg, weighting, act, energy, bond_issue, amsterdam, production, financing, investment_company, jones, valuation, nature, scheme, interest, commission, option, shortfall, vote, blood, system, price, london, alfred, professor, sutherland, sort, harris, goldman, strike, rhode_island, worker, procedure, uk, pollster, holder, picket, trust, boss, factor, prairie, institute, inventory, aaron, week, fear, percent, conspiracy, brady, looking_for, dutch, germany, chicago, democrat, conference, crash, finance_company, international_organization, text, index, association, mexico, economy, possibility, cost, assets, failure, input, sa, faust, case, model, weight, trade, november_1, expectation, prosecutor, corp, caretaker, facility, performance, supply, strength, track, marche, representative, school, dilemma, service, increase, chang, success, tax_rate, deficit, brokerage, governor, house, privatisation, city, course, chancellor, airport, stock, reform, income, morgan, margin, focus, industry, exchange, flower, minister, director, concrete, parliament, tax, combination, saving, cdc, creditor, cross, position, budget, shame, america, ship, investment_trust, line, cargo, union, money, buying, india, price_index, income_tax, speaker, ballot, debt_instrument, confidence, abu_dhabi, research, point, stanley, russia, fall, brother, mall, sector, shop, decline, city_manager, kenya, travel, impact, hong_kong, softening, tranche, power, survey, fund, work, connection, implication, eddy, property, mark, mutual_fund, picture, hearing, peso, market, program, company, jerome, wave, policy, santiago, output, management, financial_analyst, issue, protest, purpose, skeleton, bond, share, vice_president, order, landing, leader, sept, switzerland, york, couple, trader, reversal, office, university, poor, holding_company, house_of_commons, addition, egypt, manual, hedge, latin, teamster, book, target, fundamental, kaiser]"));
        System.out.println(Strings.prefixUntil("ciao#iao", SENSE_SEPARATOR));
        System.out.println(Strings.suffixUntil("ciaiao", "#ia"));
        System.out.println(Strings.trimPunctuation(",_ciao,,.:"));
        System.out.println(Strings.split("a\tb\tc\td e f g", new String[]{"\t", "\t", "\t", STRING_SEPARATOR}));
        System.out.println(Strings.rightFillWith("abc", '0', 8));
        System.out.println(Strings.format(5.258437593849, Locale.UK, 5, 8));
        System.out.println(Strings.parseLanguageParameterValues("EN , a,  b  ,c,FR,d,e,f,IT,g"));
    }
}

