/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.Language;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Stopwords {
    private static final Log log = LogFactory.getLog(Stopwords.class);
    private final Set<String> stopwords = new HashSet<String>();
    private static Map<Language, Stopwords> instances = new HashMap<Language, Stopwords>();

    public static synchronized Stopwords getInstance() {
        return Stopwords.getInstance(Language.EN);
    }

    public static synchronized Stopwords getInstance(Language language) {
        Stopwords instance = instances.get((Object)language);
        if (instance == null) {
            instance = new Stopwords(language);
            instances.put(language, instance);
        }
        return instance;
    }

    private Stopwords(Language language) {
        String swFile = Configuration.getInstance().getStopwordsFile(language);
        try {
            this.load(swFile);
        }
        catch (FileNotFoundException fnfe) {
            log.warn((Object)("No file: " + swFile + ", loading empty list"));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot load: " + ioe);
        }
    }

    public void load(String stopfile) throws IOException {
        this.load(stopfile, null);
    }

    public void load(String stopfile, String prefix) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(stopfile));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("%")) continue;
            if (prefix != null) {
                this.stopwords.add(String.valueOf(prefix) + line);
                continue;
            }
            this.stopwords.add(line);
        }
        br.close();
    }

    public boolean isStopword(String w) {
        boolean bResult = false;
        for (String s : this.stopwords) {
            if (!w.equalsIgnoreCase(s)) continue;
            bResult = true;
            break;
        }
        return bResult;
    }

    public void clear() {
        this.stopwords.clear();
    }

    public Set<String> getStopwords() {
        return this.stopwords;
    }

    public static void main(String[] args) throws IOException {
        Stopwords swList = Stopwords.getInstance();
        System.out.println("TESTING had (language " + (Object)((Object)Language.EN) + "): " + swList.isStopword("have"));
        System.out.println("TESTING hat (language " + (Object)((Object)Language.EN) + "): " + swList.isStopword("hat"));
        swList = Stopwords.getInstance(Language.ES);
        System.out.println("TESTING este (language " + (Object)((Object)Language.ES) + "): " + swList.isStopword("este"));
        swList = Stopwords.getInstance(Language.DE);
        System.out.println("TESTING dieser (language " + (Object)((Object)Language.DE) + "): " + swList.isStopword("dieser"));
        System.out.println("TESTING zug (language " + (Object)((Object)Language.DE) + "): " + swList.isStopword("zug"));
    }
}

