/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.util.Strings;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.EnglishStemmer;
import org.tartarus.snowball.ext.FrenchStemmer;
import org.tartarus.snowball.ext.GermanStemmer;
import org.tartarus.snowball.ext.ItalianStemmer;
import org.tartarus.snowball.ext.SpanishStemmer;

public class Stemmer {
    private static final Log log = LogFactory.getLog(Stemmer.class);
    private static final Map<Language, Stemmer> STEMMERS = new HashMap<Language, Stemmer>();
    private final SnowballProgram stemmer;

    private Stemmer(Language language) {
        switch (language) {
            case EN: {
                this.stemmer = new EnglishStemmer();
                break;
            }
            case DE: {
                this.stemmer = new GermanStemmer();
                break;
            }
            case FR: {
                this.stemmer = new FrenchStemmer();
                break;
            }
            case IT: {
                this.stemmer = new ItalianStemmer();
                break;
            }
            case ES: {
                this.stemmer = new SpanishStemmer();
                break;
            }
            case CA: {
                log.warn((Object)"Loading SPANISH stemmer for CATALAN (no catalan stemmer available)...");
                this.stemmer = new SpanishStemmer();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown language: " + (Object)((Object)language));
            }
        }
    }

    public String stem(String s) {
        this.stemmer.setCurrent(s);
        this.stemmer.stem();
        return this.stemmer.getCurrent();
    }

    public String stemCompound(String s) {
        ArrayList<String> stems = new ArrayList<String>();
        String[] stringArray = s.split("_");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String elem = stringArray[n2];
            stems.add(this.stem(elem));
            ++n2;
        }
        return Strings.join(stems, "_");
    }

    public List<String> stemText(String text) {
        String[] tokens = text.split("\\s+");
        ArrayList<String> stems = new ArrayList<String>();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            stems.add(this.stem(token));
            ++n2;
        }
        return stems;
    }

    public static Stemmer getStemmerForLanguage(Language language) {
        Stemmer stemmer = STEMMERS.get((Object)language);
        if (stemmer == null) {
            stemmer = new Stemmer(language);
            STEMMERS.put(language, stemmer);
        }
        return stemmer;
    }

    public static Collection<String> stemCollection(Collection<String> collection, Language language) {
        return Stemmer.stemCollection(collection, language, false);
    }

    public static Collection<String> stemCollection(Collection<String> collection, Language language, boolean stemCompounds) {
        AbstractCollection stemmed = null;
        Stemmer stemmer = Stemmer.getStemmerForLanguage(language);
        if (collection instanceof Set) {
            stemmed = new HashSet<String>();
        } else if (collection instanceof List) {
            stemmed = new ArrayList();
        }
        if (stemmed != null) {
            for (String elem : collection) {
                String stem = "";
                stem = stemCompounds ? stemmer.stemCompound(elem) : stemmer.stem(new String(elem));
                stemmed.add((String)stem);
            }
        }
        return stemmed;
    }

    public static void main(String[] args) {
        String[][] test = new String[][]{{"dogs", "cats", "architecture"}, {"acqua", "acque", "tedeschi", "tedesco"}};
        Stemmer stemmer = Stemmer.getStemmerForLanguage(Language.EN);
        String[] stringArray = test[0];
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String englishW = stringArray[n2];
            System.out.println("WORD: " + englishW + " STEM: " + stemmer.stemCompound(englishW));
            ++n2;
        }
        System.out.println("=========================");
        stemmer = Stemmer.getStemmerForLanguage(Language.IT);
        stringArray = test[1];
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String italianW = stringArray[n2];
            System.out.println("WORD: " + italianW + " STEM: " + stemmer.stemCompound(italianW));
            ++n2;
        }
    }
}

