/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SimpleFileReader<T>
implements Iterator<T>,
Iterable<T> {
    protected static final Log log = LogFactory.getLog(SimpleFileReader.class);
    protected String filename;
    protected BufferedReader lineReader;

    public SimpleFileReader(String filename) {
        this.filename = filename;
    }

    @Override
    public Iterator<T> iterator() {
        try {
            this.lineReader = new BufferedReader(new FileReader(this.filename));
        }
        catch (FileNotFoundException e) {
            log.info((Object)e.getMessage());
            e.printStackTrace();
        }
        return this;
    }

    protected String readLine() {
        String line = null;
        try {
            line = this.lineReader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return line;
    }

    protected List<String> findNextLine(String line, Pattern p) {
        Matcher m = p.matcher(line);
        ArrayList<String> founds = new ArrayList<String>();
        while (m.find()) {
            int i = 1;
            while (i <= m.groupCount()) {
                if (m.group(i) != null) {
                    founds.add(m.group(i));
                }
                ++i;
            }
        }
        return founds;
    }

    @Override
    public void remove() {
        try {
            this.lineReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        if (this.lineReader != null) {
            try {
                this.lineReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

