/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.ScoredItem;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ScoredStringComparator
implements Comparator<ScoredItem<String>> {
    @Override
    public int compare(ScoredItem<String> o1, ScoredItem<String> o2) {
        int scoreComparison = Double.compare(o2.getScore(), o1.getScore());
        if (scoreComparison == 0) {
            return o1.getItem().compareTo(o2.getItem());
        }
        return scoreComparison;
    }

    public static Set<ScoredItem<String>> getHighestScoredItems(Collection<ScoredItem<String>> items) {
        double bestScore = 0.0;
        TreeSet<ScoredItem<String>> all = null;
        if (items instanceof SortedSet) {
            all = (TreeSet<ScoredItem<String>>)items;
        } else {
            all = new TreeSet<ScoredItem<String>>(new ScoredStringComparator());
            all.addAll(items);
        }
        TreeSet<ScoredItem<String>> best = new TreeSet<ScoredItem<String>>(new ScoredStringComparator());
        for (ScoredItem scoredItem : all) {
            if (best.isEmpty()) {
                best.add(scoredItem);
                bestScore = scoredItem.getScore();
                continue;
            }
            if (scoredItem.getScore() != bestScore) break;
            best.add(scoredItem);
        }
        return best;
    }

    public static Set<ScoredItem<String>> getLowestScoredItems(Collection<ScoredItem<String>> items) {
        double worstScore = Double.MAX_VALUE;
        SortedSet<ScoredItem<String>> all = new TreeSet<ScoredItem<String>>(new ScoredStringComparator());
        all.addAll(items);
        all = all.tailSet((ScoredItem)all.last());
        TreeSet<ScoredItem<String>> worst = new TreeSet<ScoredItem<String>>(new ScoredStringComparator());
        for (ScoredItem scoredItem : all) {
            if (worst.isEmpty()) {
                worst.add(scoredItem);
                worstScore = scoredItem.getScore();
                continue;
            }
            if (scoredItem.getScore() != worstScore) break;
            worst.add(scoredItem);
        }
        return worst;
    }
}

