/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.FormattedFileReader;
import it.uniroma1.lcl.jlt.util.SimpleFileReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class RecordFormattedFileReader
extends SimpleFileReader<Set<List<String>>>
implements Iterator<Set<List<String>>> {
    protected Pattern startRecordFormat;
    protected Pattern endRecordFormat;
    protected Pattern lineFormat;
    protected Set<List<String>> record = new HashSet<List<String>>();

    public RecordFormattedFileReader(String filename, String startRecordFormat, String endRecordFormat, FormattedFileReader.COMMON_FORMATS lineFormat) {
        this(filename, startRecordFormat, endRecordFormat, lineFormat.toString());
    }

    public RecordFormattedFileReader(String filename, String recordFormat, FormattedFileReader.COMMON_FORMATS lineFormat) {
        this(filename, recordFormat, recordFormat.replace("<", "</"), lineFormat);
    }

    public RecordFormattedFileReader(String filename, String recordFormat, String lineFormat) {
        this(filename, recordFormat, recordFormat.replace("<", "</"), lineFormat);
    }

    public RecordFormattedFileReader(String filename, String startRecordFormat, String endRecordFormat, String lineFormat) {
        super(filename);
        this.lineFormat = Pattern.compile(lineFormat);
        this.startRecordFormat = Pattern.compile(startRecordFormat);
        this.endRecordFormat = Pattern.compile(endRecordFormat);
    }

    @Override
    public boolean hasNext() {
        String line;
        this.record.clear();
        while ((line = this.readLine()) != null && this.findNextLine(line, this.startRecordFormat).isEmpty()) {
        }
        if (line == null) {
            return false;
        }
        List<String> results = null;
        while ((line = this.readLine()) != null && (results = this.findNextLine(line, this.endRecordFormat)).isEmpty()) {
            results = this.findNextLine(line, this.lineFormat);
            if (results.isEmpty()) continue;
            this.record.add(results);
        }
        return line != null && !results.isEmpty();
    }

    @Override
    public Set<List<String>> next() {
        return this.record;
    }

    public static void main(String[] args) {
        RecordFormattedFileReader reader = new RecordFormattedFileReader("/home/flati/Scaricati/test/recordfiletest.txt", "<(Persona)>", FormattedFileReader.COMMON_FORMATS.PARAMETER_AND_VALUE);
        for (Set record : reader) {
            log.info((Object)"== New record found == ");
            for (List fields : record) {
                log.info((Object)("FIELDS: " + fields));
            }
        }
    }
}

