/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.NGramModel;
import it.uniroma1.lcl.jlt.util.Sets;
import java.util.Collection;
import java.util.Set;

public class NGramModelOOV
extends NGramModel {
    private Collection<String> vocabulary;

    public NGramModelOOV(Collection<String> vocabulary, int N) {
        super(N);
        this.vocabulary = vocabulary;
    }

    @Override
    public void build(String[] tokens) {
        int k = 0;
        while (k < tokens.length) {
            if (!this.vocabulary.contains(tokens[k])) {
                tokens[k] = "<UNK>";
            }
            ++k;
        }
        super.build(tokens);
    }

    public static void main(String[] args) {
        String[] seq = new String[]{"a", "a", "b", "c", "d", "e", "a", "b", "a", "b"};
        Set<String> voc = Sets.varargsToHashSet("a", "b", "c");
        NGramModelOOV model1 = new NGramModelOOV(voc, 1);
        ((NGramModel)model1).build(seq);
        System.out.println(model1.getProbability("<UNK>", new String[0]));
        NGramModelOOV model2 = new NGramModelOOV(voc, 2);
        ((NGramModel)model2).build(seq);
        System.out.println(model2.getProbability("a", "<UNK>"));
        System.out.println(model2.getProbability("c", "<UNK>"));
        System.out.println(model2.getProbability("<UNK>", "a"));
        System.out.println(model2.getProbability("a", "a"));
        NGramModelOOV model3 = new NGramModelOOV(voc, 3);
        ((NGramModel)model3).build(seq);
        System.out.println(model3.getProbability("a", "a", "b"));
        System.out.println(model3.getProbability("b", "a", "b"));
        System.out.println(model3.getProbability("c", "a", "b"));
        System.out.println(model3.getProbability("a", "a", "a"));
        System.out.println(model3.getProbability("b", "a", "a"));
        System.out.println(model3.getProbability("c", "c", "d"));
    }
}

