/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.Arrays;
import it.uniroma1.lcl.jlt.util.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class NGramModel {
    private int N;
    private Map<String, Map<String, Integer>> count;
    public static final String TOTAL_KEY = "_TOTAL_";

    public NGramModel(int N) {
        this.N = N;
    }

    public void build(String[] tokens) {
        this.count = new HashMap<String, Map<String, Integer>>();
        int k = this.N - 1;
        while (k < tokens.length) {
            Map<String, Integer> distribution;
            Integer v;
            String h = Strings.join(tokens, k - this.N + 1, k - 1, "_");
            if (!this.count.containsKey(h)) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put(TOTAL_KEY, 0);
                this.count.put(h, map);
            }
            if ((v = (distribution = this.count.get(h)).get(tokens[k])) == null) {
                v = 0;
            }
            distribution.put(tokens[k], v + 1);
            distribution.put(TOTAL_KEY, distribution.get(TOTAL_KEY) + 1);
            ++k;
        }
    }

    public double getProbability(String w, String ... h) {
        String hs = Strings.join(h, 0, h.length - 1, "_");
        Map<String, Integer> c = this.count.get(hs);
        if (c == null) {
            return 0.0;
        }
        Integer num = c.get(w);
        if (num == null) {
            return 0.0;
        }
        return (double)num.intValue() / (double)c.get(TOTAL_KEY).intValue();
    }

    public String generateFrom(String stoppingWord, String ... h) {
        String w;
        StringBuffer sb = new StringBuffer();
        String[] stringArray = h;
        int n = h.length;
        int n2 = 0;
        while (n2 < n) {
            w = stringArray[n2];
            sb.append(String.valueOf(w) + "_");
            ++n2;
        }
        w = null;
        do {
            w = this.getNextWord(h);
            sb.append(String.valueOf(w) + "_");
            h = Arrays.push(Arrays.subArray(Arrays.shift(h, -1), 0, h.length - 1), w);
        } while (!w.equals(stoppingWord));
        return sb.toString();
    }

    public String getNextWord(String ... h) {
        String hs = Strings.join(h, 0, h.length - 1, "_");
        int total = this.count.get(hs).get(TOTAL_KEY);
        Random r = new Random();
        int min = r.nextInt(total);
        int k = 0;
        for (String w : this.count.get(hs).keySet()) {
            if (w.equals(TOTAL_KEY) || (k += this.count.get(hs).get(w).intValue()) <= min) continue;
            return w;
        }
        return null;
    }

    public static void main(String[] args) {
        String[] seq = new String[]{"a", "a", "b", "c", "d", "e", "a", "b", "a", "b"};
        NGramModel model1 = new NGramModel(1);
        model1.build(seq);
        System.out.println(model1.getProbability("a", new String[0]));
        System.out.println(model1.getProbability("b", new String[0]));
        System.out.println(model1.getProbability("c", new String[0]));
        System.out.println(model1.getProbability("d", new String[0]));
        NGramModel model2 = new NGramModel(2);
        model2.build(seq);
        System.out.println(model2.getProbability("b", "a"));
        System.out.println(model2.getProbability("c", "b"));
        System.out.println(model2.getProbability("d", "c"));
        System.out.println(model2.getProbability("a", "a"));
        NGramModel model3 = new NGramModel(3);
        model3.build(seq);
        System.out.println(model3.getProbability("a", "a", "b"));
        System.out.println(model3.getProbability("b", "a", "b"));
        System.out.println(model3.getProbability("c", "a", "b"));
        System.out.println(model3.getProbability("a", "a", "a"));
        System.out.println(model3.getProbability("b", "a", "a"));
        System.out.println(model3.getProbability("c", "c", "d"));
        System.out.println(model3.generateFrom("e", "a", "b"));
    }
}

