/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Multimaps {
    public static <K, V> void writeMap(Multimap<K, V> map, String sink) throws IOException {
        Multimaps.writeMap(map, sink, false);
    }

    public static <K, V> void writeMap(Multimap<K, V> map, String sink, boolean append) throws IOException {
        File sinkDir = new File(sink).getParentFile();
        if (!sinkDir.exists()) {
            sinkDir.mkdirs();
        }
        FileWriter writer = new FileWriter(sink, append);
        for (Object key : map.keySet()) {
            writer.write(key.toString());
            for (Object value : map.get(key)) {
                writer.write("\t" + value.toString());
            }
            writer.write("\n");
        }
        writer.flush();
        writer.close();
    }

    public static Multimap<String, String> readMap(String src) throws IOException {
        return Multimaps.populateMap(src, (Multimap<String, String>)new HashMultimap());
    }

    public static Multimap<String, String> readLinkedHashMultimap(String src) throws IOException {
        return Multimaps.populateMap(src, (Multimap<String, String>)new LinkedHashMultimap());
    }

    public static Multimap<String, String> readTreeMultimap(String src) throws IOException {
        return Multimaps.populateMap(src, (Multimap<String, String>)new TreeMultimap());
    }

    private static Multimap<String, String> populateMap(String src, Multimap<String, String> map) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(src));
        while (reader.ready()) {
            String line = reader.readLine();
            String[] split = line.split("\\t+");
            String key = split[0];
            if (split.length <= 1) continue;
            int value = 1;
            while (value < split.length) {
                map.put((Object)key, (Object)split[value]);
                ++value;
            }
        }
        reader.close();
        return map;
    }
}

