/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import com.google.common.collect.Sets;
import edu.stanford.nlp.util.StringUtils;
import it.uniroma1.lcl.jlt.util.DoubleCounter;
import it.uniroma1.lcl.jlt.util.IntegerCounter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class Measures {
    public static <E> double getSimilarity(Collection<E> u, Collection<E> v, MeasureLabel measure) {
        if (u == null || v == null) {
            return 0.0;
        }
        switch (measure) {
            case DICE: {
                return Measures.Dice(u, v);
            }
            case JACCARD: {
                return Measures.Jaccard(u, v);
            }
            case BOW: {
                return Measures.Bow(u, v);
            }
        }
        throw new RuntimeException("Measure " + (Object)((Object)measure) + " not implemented yet.");
    }

    public static <E> double getSimilarity(Map<E, ? extends Number> u, Map<E, ? extends Number> v, MeasureLabel measure) {
        if (u == null || v == null) {
            return 0.0;
        }
        switch (measure) {
            case DICE: {
                return Measures.Dice(u, v);
            }
            case JACCARD: {
                return Measures.Jaccard(u, v);
            }
            case COSINE: {
                return Measures.cosineSimilarity(u, v);
            }
            case NGCM: {
                return Measures.nGCM(u, v);
            }
            case BOW: {
                return Measures.Bow(u.keySet(), v.keySet());
            }
        }
        throw new RuntimeException("Measure " + (Object)((Object)measure) + " not implemented yet.");
    }

    public static <E> double Jaccard(Collection<E> u, Collection<E> v) {
        double common = CollectionUtils.intersection(u, v).size();
        double union = CollectionUtils.union(u, v).size();
        if (union == 0.0) {
            return 0.0;
        }
        return common / union;
    }

    public static <K> double Jaccard(Map<K, ? extends Number> u, Map<K, ? extends Number> v) {
        return Measures.Jaccard(u.keySet(), v.keySet());
    }

    public static <E> double Dice(Collection<E> u, Collection<E> v) {
        if (u.isEmpty() || v.isEmpty()) {
            return 0.0;
        }
        double common = CollectionUtils.intersection(u, v).size();
        double den1 = u.size();
        double den2 = v.size();
        return 2.0 * common / (den1 + den2);
    }

    public static <K> double Dice(Map<K, ? extends Number> u, Map<K, ? extends Number> v) {
        return Measures.Dice(u.keySet(), v.keySet());
    }

    public static <E> double Bow(Collection<E> u, Collection<E> v) {
        return CollectionUtils.intersection(u, v).size();
    }

    public static <K> double cosineSimilarity(Map<K, ? extends Number> u, Map<K, ? extends Number> v) {
        double u_norm = Measures.norm2(u);
        if (u_norm == 0.0) {
            return 0.0;
        }
        double v_norm = Measures.norm2(v);
        if (v_norm == 0.0) {
            return 0.0;
        }
        return Measures.dotProduct(u, v) / (u_norm * v_norm);
    }

    public static <K> double cosineSimilarity(IntegerCounter<K> u, IntegerCounter<K> v) {
        HashMap uMap = new HashMap();
        for (Object key : u.keySet()) {
            uMap.put(key, (Integer)u.get(key));
        }
        HashMap vMap = new HashMap();
        for (Object key : v.keySet()) {
            vMap.put(key, (Integer)v.get(key));
        }
        return Measures.cosineSimilarity(uMap, vMap);
    }

    public static <K> double cosineSimilarity(DoubleCounter<K> u, DoubleCounter<K> v) {
        HashMap uMap = new HashMap();
        for (Object key : u.keySet()) {
            uMap.put(key, (Double)u.get(key));
        }
        HashMap vMap = new HashMap();
        for (Object key : v.keySet()) {
            vMap.put(key, (Double)v.get(key));
        }
        return Measures.cosineSimilarity(uMap, vMap);
    }

    public static <K> double dotProduct(Map<K, ? extends Number> vector1, Map<K, ? extends Number> vector2) {
        double dotProduct = 0.0;
        Map<K, Number> temp = null;
        if (vector1.size() > vector2.size()) {
            temp = vector1;
            vector1 = vector2;
            vector2 = temp;
        }
        for (K key : vector1.keySet()) {
            Number value = vector2.get(key);
            if (value == null) continue;
            dotProduct += vector1.get(key).doubleValue() * value.doubleValue();
        }
        return dotProduct;
    }

    public static <K> double dotProduct(IntegerCounter<K> vector1, IntegerCounter<K> vector2) {
        double dotProduct = 0.0;
        IntegerCounter temp = null;
        if (vector1.size() > vector2.size()) {
            temp = vector1;
            vector1 = vector2;
            vector2 = temp;
        }
        for (Object key : vector1.keySet()) {
            Integer value = (Integer)vector2.get(key);
            if (value == null) continue;
            dotProduct += (double)((Integer)vector1.get(key) * value);
        }
        return dotProduct;
    }

    public static <K> double norm2(Map<K, ? extends Number> vector) {
        double norm = 0.0;
        for (Number number : vector.values()) {
            norm += number.doubleValue() * number.doubleValue();
        }
        norm = Math.sqrt(norm);
        return norm;
    }

    public static <K> double norm2(IntegerCounter<K> vector) {
        double norm = 0.0;
        for (Number value : vector.getValues()) {
            norm += value.doubleValue() * value.doubleValue();
        }
        norm = Math.sqrt(norm);
        return norm;
    }

    public static <K> double nGCM(Map<K, ? extends Number> u, Map<K, ? extends Number> v) {
        double normU = Measures.norm2(u);
        if (normU == 0.0) {
            return 0.0;
        }
        double normV = Measures.norm2(v);
        if (normV == 0.0) {
            return 0.0;
        }
        double result = 0.0;
        for (Object key : Sets.intersection(u.keySet(), v.keySet())) {
            result += Math.pow(u.get(key).doubleValue() / normU - v.get(key).doubleValue() / normV, 2.0);
        }
        return Math.exp(-Math.sqrt(result));
    }

    public static void main(String[] args) {
        System.out.println(StringUtils.repeat((char)'=', (int)100));
        System.out.println(String.valueOf(StringUtils.repeat((char)'=', (int)45)) + " MEASURES " + StringUtils.repeat((char)'=', (int)45));
        System.out.println(String.valueOf(StringUtils.repeat((char)'=', (int)100)) + "\n\n");
        HashMap<String, Integer> vector1 = new HashMap<String, Integer>();
        vector1.put("Potato", 3);
        vector1.put("Tomato", 9);
        vector1.put("Stick", 10);
        vector1.put("Cigarette", 7);
        vector1.put("Cakes", 8);
        HashMap<String, Integer> vector2 = new HashMap<String, Integer>();
        vector2.put("Potato", 1);
        vector2.put("Tomato", 4);
        vector2.put("Chocolate", 3);
        vector2.put("Cakes", 2);
        vector2.put("Cigarette", 0);
        vector2.put("Sugar", 0);
        System.out.println("VECTOR1 := " + vector1);
        System.out.println("VECTOR2 := " + vector2);
        System.out.println("\n\n" + StringUtils.repeat((char)'=', (int)45) + " JACCARD " + StringUtils.repeat((char)'=', (int)45));
        System.out.println("Jaccard: " + Measures.Jaccard(vector1, vector2));
        System.out.println("\t|VECTOR1 intersected VECTOR2| = " + Sets.intersection(vector1.keySet(), vector2.keySet()).size());
        System.out.println("\t|VECTOR1 union VECTOR2| = " + Sets.union(vector1.keySet(), vector2.keySet()).size());
        System.out.println("\n\n" + StringUtils.repeat((char)'=', (int)45) + " DICE " + StringUtils.repeat((char)'=', (int)45));
        System.out.println("Dice: " + Measures.Dice(vector1, vector2));
        System.out.println("\t|VECTOR1 intersected VECTOR2| = " + Sets.intersection(vector1.keySet(), vector2.keySet()).size());
        System.out.println("\t|VECTOR1| = " + vector1.keySet().size());
        System.out.println("\t|VECTOR2| = " + vector2.keySet().size());
        System.out.println("\n\n" + StringUtils.repeat((char)'=', (int)45) + " COSINE " + StringUtils.repeat((char)'=', (int)45));
        System.out.println("Cosine: " + Measures.cosineSimilarity(vector1, vector2));
        System.out.println("\tdotProduct(VECTOR1, VECTOR2) = " + Measures.dotProduct(vector1, vector2));
        System.out.println("\tnorm2(VECTOR1) = " + Measures.norm2(vector1));
        System.out.println("\tnorm2(VECTOR2) = " + Measures.norm2(vector2));
        System.out.println(StringUtils.repeat((char)'=', (int)100));
    }

    public static enum MeasureLabel {
        DICE,
        JACCARD,
        COSINE,
        NGCM,
        BOW;

    }
}

