/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.DoubleCounter;
import it.uniroma1.lcl.jlt.util.IntegerCounter;
import it.uniroma1.lcl.jlt.util.Pair;
import it.uniroma1.lcl.jlt.util.Scorable;
import it.uniroma1.lcl.jlt.util.Strings;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class Maths {
    private static final Random RANDOM = new Random(System.currentTimeMillis());

    public static double log(double a, double base) {
        return Math.log(a) / Math.log(base);
    }

    public static double log2(double a) {
        return Maths.log(a, 2.0);
    }

    public static double multiply(Double ... factors) {
        return Maths.multiply(Arrays.asList(factors));
    }

    public static double multiply(Collection<Double> factors) {
        double score = 0.0;
        for (double factor : factors) {
            score += Math.log(factor);
        }
        return Math.exp(score);
    }

    public static double sum(Collection<? extends Number> addends) {
        double score = 0.0;
        for (Number number : addends) {
            score += number.doubleValue();
        }
        return score;
    }

    public static double round(double d, int scale) {
        BigDecimal round = new BigDecimal(d);
        round = round.setScale(scale, 4);
        return round.doubleValue();
    }

    public static int binomial(int n, int m) {
        if (n < 0) {
            throw new RuntimeException("Negative \"n\"");
        }
        if (m > n || m < 0) {
            throw new RuntimeException("Invalid \"m\"");
        }
        int[] b = new int[n + 1];
        b[0] = 1;
        int i = 1;
        while (i <= n) {
            b[i] = 1;
            int j = i - 1;
            while (j > 0) {
                int n2 = j;
                b[n2] = b[n2] + b[j - 1];
                --j;
            }
            ++i;
        }
        return b[m];
    }

    public static double mean(Collection<? extends Number> list) {
        if (list.isEmpty()) {
            return 0.0;
        }
        double avg = 0.0;
        for (Number number : list) {
            avg += number.doubleValue();
        }
        return avg /= (double)list.size();
    }

    public static double median(Collection<? extends Number> collection) {
        if (collection.isEmpty()) {
            return 0.0;
        }
        double median = 0.0;
        ArrayList<Double> list = new ArrayList<Double>();
        for (Number number : collection) {
            list.add(number.doubleValue());
        }
        if (collection.size() % 2 == 1) {
            median = (Double)list.get((list.size() + 1) / 2 - 1);
        } else {
            double d = (Double)list.get(list.size() / 2 - 1);
            double upper = (Double)list.get(list.size() / 2);
            median = (d + upper) / 2.0;
        }
        return median;
    }

    public static double max(Collection<? extends Number> list) {
        double max = Double.MIN_VALUE;
        if (list.isEmpty()) {
            return max;
        }
        for (Number number : list) {
            max = Math.max(max, number.doubleValue());
        }
        return max;
    }

    public static double min(Collection<? extends Number> list) {
        double min = Double.MAX_VALUE;
        if (list.isEmpty()) {
            return min;
        }
        for (Number number : list) {
            min = Math.min(min, number.doubleValue());
        }
        return min;
    }

    public static double linearCombination(double v1, double v2, double alpha) {
        return alpha * v1 + (1.0 - alpha) * v2;
    }

    public static double stddeviation(Collection<? extends Number> list) {
        if (list.isEmpty()) {
            return 0.0;
        }
        double avg = Maths.mean(list);
        double stddev = 0.0;
        for (Number number : list) {
            stddev += Math.pow(number.doubleValue() - avg, 2.0);
        }
        return Math.sqrt(stddev /= (double)list.size());
    }

    public static double RSD(Collection<? extends Number> list) {
        return Maths.stddeviation(list) / Maths.mean(list);
    }

    public static <T extends Scorable> Pair<T, Double> argMax(Collection<T> scorables) {
        Scorable best = null;
        double bestScore = Double.MIN_VALUE;
        for (Scorable scorable : scorables) {
            double score = scorable.getScore();
            if (!(score > bestScore)) continue;
            best = scorable;
            bestScore = score;
        }
        return new Pair<Object, Double>(best, bestScore);
    }

    public static <T extends Scorable> Pair<T, Double> argMin(Collection<T> scorables) {
        Scorable best = null;
        double bestScore = Double.MAX_VALUE;
        for (Scorable scorable : scorables) {
            double score = scorable.getScore();
            if (!(score < bestScore)) continue;
            best = scorable;
            bestScore = score;
        }
        return new Pair<Object, Double>(best, bestScore);
    }

    public static double weighted_mean(Collection<? extends Number> list, Collection<? extends Number> weights) {
        double avg = 0.0;
        Iterator<? extends Number> values_iterator = list.iterator();
        Iterator<? extends Number> weights_iterator = weights.iterator();
        double total = 0.0;
        while (values_iterator.hasNext()) {
            Number value = values_iterator.next();
            Number weight = weights_iterator.next();
            avg += value.doubleValue() * weight.doubleValue();
            total += weight.doubleValue();
        }
        return avg /= total;
    }

    public static double entropy(double p) {
        if (p == 0.0 || p == 1.0) {
            return 0.0;
        }
        return -1.0 * p * Math.log(p) - (1.0 - p) * Math.log(1.0 - p);
    }

    public static double entropy(Collection<Double> distribution) {
        double entropy = 0.0;
        for (Double value : distribution) {
            if (value == 0.0 || value == 1.0) continue;
            entropy += -value.doubleValue() * Math.log(value);
        }
        return entropy;
    }

    public static double entropyNormalized(Collection<Double> distribution) {
        return Maths.entropy(distribution) / Math.log(distribution.size());
    }

    public static boolean tossBiasedCoin(double p) {
        return RANDOM.nextDouble() <= p;
    }

    public static Random getGenerator() {
        return RANDOM;
    }

    public static <T> List<T> getRandomSelection(List<T> list, int k) {
        ArrayList<T> random_list = new ArrayList<T>();
        for (Integer random_index : Maths.generateRandomNumbers(k, list.size())) {
            random_list.add(list.get(random_index));
        }
        return random_list;
    }

    public static Set<Integer> generateRandomNumbers(int k, int max) {
        int todraw = Math.min(k, max);
        Random gen = Maths.getGenerator();
        HashSet<Integer> indices = new HashSet<Integer>(todraw);
        while (indices.size() < todraw) {
            indices.add(gen.nextInt(max));
        }
        return indices;
    }

    public static double getPercentage(Number n, Number m) {
        return 100.0 * Maths.getProbability(n, m);
    }

    public static String getFormattedPercentage(Number n, Number m) {
        return String.valueOf(Strings.format(100.0 * Maths.getProbability(n, m), Locale.UK, 0, 2)) + "%";
    }

    public static double getProbability(Number n, Number m) {
        if (m.doubleValue() == 0.0) {
            return 0.0;
        }
        return n.doubleValue() / m.doubleValue();
    }

    public static double pmi(double xy, double x, double y) {
        double ratio = x == 0.0 || y == 0.0 ? 0.0 : xy / (x * y);
        return Math.log(ratio);
    }

    public static double dice(double xy, double x, double y) {
        if (x == 0.0 || y == 0.0) {
            return 0.0;
        }
        return 2.0 * xy / (x + y);
    }

    public static <K> double dotProduct(Map<K, ? extends Number> vector1, Map<K, ? extends Number> vector2) {
        double dotProduct = 0.0;
        Map<K, Number> temp = null;
        if (vector1.size() > vector2.size()) {
            temp = vector1;
            vector1 = vector2;
            vector2 = temp;
        }
        for (K key : vector1.keySet()) {
            Number value = vector2.get(key);
            if (value == null) continue;
            dotProduct += vector1.get(key).doubleValue() * value.doubleValue();
        }
        return dotProduct;
    }

    public static <K> double dotProduct(IntegerCounter<K> vector1, IntegerCounter<K> vector2) {
        double dotProduct = 0.0;
        IntegerCounter temp = null;
        if (vector1.size() > vector2.size()) {
            temp = vector1;
            vector1 = vector2;
            vector2 = temp;
        }
        for (Object key : vector1.keySet()) {
            Integer value = (Integer)vector2.get(key);
            if (value == null) continue;
            dotProduct += (double)((Integer)vector1.get(key) * value);
        }
        return dotProduct;
    }

    public static <K> double norm2(Map<K, ? extends Number> vector) {
        double norm = 0.0;
        for (Number number : vector.values()) {
            norm += number.doubleValue() * number.doubleValue();
        }
        norm = Math.sqrt(norm);
        return norm;
    }

    public static <K> double norm2(IntegerCounter<K> vector) {
        double norm = 0.0;
        for (Number value : vector.getValues()) {
            norm += value.doubleValue() * value.doubleValue();
        }
        norm = Math.sqrt(norm);
        return norm;
    }

    public static <K> void filterVector(Map<K, ? extends Number> v, Number minValue) {
        HashSet<K> keys = new HashSet<K>(v.keySet());
        for (Object k : keys) {
            if (!(v.get(k).doubleValue() < minValue.doubleValue())) continue;
            v.remove(k);
        }
    }

    public static <K> double cosineSimilarity(Map<K, ? extends Number> u, Map<K, ? extends Number> v) {
        double u_norm = Maths.norm2(u);
        if (u_norm == 0.0) {
            return 0.0;
        }
        double v_norm = Maths.norm2(v);
        if (v_norm == 0.0) {
            return 0.0;
        }
        return Maths.dotProduct(u, v) / (u_norm * v_norm);
    }

    public static <K> double cosineSimilarity(IntegerCounter<K> u, IntegerCounter<K> v) {
        double u_norm = Maths.norm2(u);
        if (u_norm == 0.0) {
            return 0.0;
        }
        double v_norm = Maths.norm2(v);
        if (v_norm == 0.0) {
            return 0.0;
        }
        return Maths.dotProduct(u, v) / (u_norm * v_norm);
    }

    public static <K> double cosineSimilarity(DoubleCounter<K> u, DoubleCounter<K> v) {
        HashMap uMap = new HashMap();
        for (Object key : u.keySet()) {
            uMap.put(key, (Double)u.get(key));
        }
        HashMap vMap = new HashMap();
        for (Object key : v.keySet()) {
            vMap.put(key, (Double)v.get(key));
        }
        return Maths.cosineSimilarity(uMap, vMap);
    }

    public static void main(String[] args) {
        System.out.println(Maths.dice(63560.0, 2386.0, 61174.0));
        System.exit(0);
        ArrayList<Double> values = new ArrayList<Double>();
        ArrayList<Double> weights = new ArrayList<Double>();
        int[] array_values = new int[]{1, 2, 3, 4, 5};
        double[] array_weights = new double[]{0.1, 0.5, 0.5, 0.5, 1.0};
        Object[] objectArray = array_values;
        int n = array_values.length;
        int n2 = 0;
        while (n2 < n) {
            double d = objectArray[n2];
            values.add(d);
            ++n2;
        }
        objectArray = array_weights;
        n = array_weights.length;
        n2 = 0;
        while (n2 < n) {
            int w = objectArray[n2];
            weights.add(Double.valueOf(w));
            ++n2;
        }
        System.out.println("=== EXAMPLE 1 - (EASY, HANDMADE) ===\n");
        System.out.println("VALUES := " + values);
        System.out.println("WEIGHTS := " + weights);
        System.out.println();
        System.out.println("MEAN: " + Maths.mean(values));
        System.out.println("WEIGHTED MEAN: " + Maths.weighted_mean(values, weights));
        System.out.println("STANDARD DEVIATION: " + Maths.stddeviation(values));
        System.out.println("RSD: " + Maths.RSD(values));
        int max = 5;
        int n3 = 10;
        Random generator = Maths.getGenerator();
        System.out.println("\n\n");
        values.clear();
        weights.clear();
        int i = 0;
        while (i < n3) {
            values.add(generator.nextDouble() * (double)generator.nextInt(max));
            weights.add(generator.nextDouble());
            ++i;
        }
        System.out.println("=== EXAMPLE 2 - (MIDDLE, RANDOM GENERATED) ===\n");
        System.out.println("VALUES := " + values);
        System.out.println("WEIGHTS := " + weights);
        System.out.println();
        System.out.println("MEAN: " + Maths.mean(values));
        System.out.println("WEIGHTED MEAN: " + Maths.weighted_mean(values, weights));
        System.out.println("STANDARD DEVIATION: " + Maths.stddeviation(values));
        System.out.println("RSD: " + Maths.RSD(values));
        System.out.println("\n\n=== EXAMPLE 3 - (VECTOR + NORM + DOT PRODUCT) ===\n");
        HashMap<String, Integer> vector1 = new HashMap<String, Integer>();
        vector1.put("Potato", 3);
        vector1.put("Tomato", 9);
        vector1.put("Stick", 10);
        vector1.put("Cigarette", 7);
        vector1.put("Cakes", 8);
        System.out.println("VECTOR1 := " + vector1);
        System.out.println("NORM(VECTOR1) := " + Maths.norm2(vector1));
        HashMap<String, Integer> vector2 = new HashMap<String, Integer>();
        vector2.put("Potato", 1);
        vector2.put("Tomato", 4);
        vector2.put("Chocolate", 3);
        vector2.put("Cakes", 2);
        vector2.put("Cigarette", 0);
        vector2.put("Sugar", 0);
        System.out.println("VECTOR2 := " + vector2);
        System.out.println("NORM(VECTOR2) := " + Maths.norm2(vector2));
        System.out.println("DOT PRODUCT := " + Maths.dotProduct(vector1, vector2));
        System.out.println("COSINE SIMILARITY := " + Maths.cosineSimilarity(vector1, vector2));
    }
}

