/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class Maps {
    public static <K, V> void writeMap(Map<K, V> map, String sink) throws IOException {
        File sinkDir = new File(sink).getParentFile();
        if (!sinkDir.exists()) {
            sinkDir.mkdirs();
        }
        FileWriter writer = new FileWriter(sink);
        for (K key : map.keySet()) {
            V value = map.get(key);
            writer.write(String.valueOf(key.toString()) + "\t" + value.toString());
            writer.write("\n");
        }
        writer.flush();
        writer.close();
    }

    public static Map<String, String> readMap(String src) throws IOException {
        return Maps.populateMap(new HashMap<String, String>(), src, false);
    }

    public static Map<String, String> readMap(String src, boolean reverse) throws IOException {
        return Maps.populateMap(new HashMap<String, String>(), src, reverse);
    }

    public static Map<String, String> populateMap(Map<String, String> map, String src, boolean reverse) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(src));
        while (reader.ready()) {
            String value;
            String key;
            String line = reader.readLine();
            String[] split = line.split("\\t+");
            if (split.length != 2) {
                throw new IllegalArgumentException("INVALID FORMAT (2 cols expected...)" + split);
            }
            if (reverse) {
                key = split[1].trim();
                value = split[0].trim();
            } else {
                key = split[0].trim();
                value = split[1].trim();
            }
            map.put(key, value);
        }
        reader.close();
        return map;
    }

    public static <K, V extends Comparable<V>> Map<K, V> sortByValue(Map<K, V> map) {
        return Maps.sortByValue(map, SortingOrder.ASCENDING);
    }

    public static <K, V extends Comparable<V>> Map<K, V> sortByValue(Map<K, V> map, SortingOrder sortingOrder) {
        Comparator valueComparator = null;
        valueComparator = sortingOrder == SortingOrder.DESCENDING ? new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o2.getValue()).compareTo((Comparable)o1.getValue());
            }
        } : new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getValue()).compareTo((Comparable)o2.getValue());
            }
        };
        return Maps.sort(map, valueComparator);
    }

    public static <K, V> Multimap<V, K> reverseToMultimap(Map<K, V> map) {
        HashMultimap multimap = new HashMultimap();
        for (K key : map.keySet()) {
            multimap.put(map.get(key), key);
        }
        return multimap;
    }

    public static <K, V> Map<K, V> sort(Map<K, V> map, Comparator<Map.Entry<K, V>> comparator) {
        LinkedList<Map.Entry<K, V>> entries = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(entries, comparator);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : entries) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K> Map<K, Integer> add(Map<K, Integer> map1, Map<K, Integer> map2) {
        HashMap<K, Integer> sum = new HashMap<K, Integer>();
        for (K key : map1.keySet()) {
            sum.put(key, map1.get(key));
        }
        for (K key : map2.keySet()) {
            Integer prec = (Integer)sum.get(key);
            if (prec == null) {
                prec = 0;
            }
            sum.put(key, prec + map2.get(key));
        }
        return sum;
    }

    public static enum SortingOrder {
        DESCENDING,
        ASCENDING;

    }
}

