/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.MapCounter;
import it.uniroma1.lcl.jlt.util.Pair;
import it.uniroma1.lcl.jlt.util.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapCounterReader
implements Iterator<MapCounter<String, String>> {
    protected static final Log log = LogFactory.getLog(MapCounterReader.class);
    private int linesRead;
    private Scanner reader;

    public MapCounterReader(String filename) {
        log.info((Object)("Created a new MapCounterReader for file: " + filename));
        try {
            this.reader = new Scanner(new File(filename));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.reader.hasNextLine();
        if (!hasNext) {
            this.reader.close();
        }
        return hasNext;
    }

    @Override
    public MapCounter<String, String> next() {
        String line = this.reader.nextLine();
        ++this.linesRead;
        Pair<String, String> pair = Strings.splitToPair(line, "\t");
        String word1 = pair.getFirst();
        MapCounter<String, String> map = new MapCounter<String, String>(word1);
        String words = pair.getSecond();
        for (String wordCount2 : Strings.split(words, ",")) {
            int lastIndex;
            String word2;
            if (!wordCount2.contains(":") || (word2 = wordCount2.substring(0, lastIndex = wordCount2.lastIndexOf(58))).isEmpty()) continue;
            try {
                map.count(word1, word2, Integer.parseInt(wordCount2.substring(lastIndex + 1)));
            }
            catch (NumberFormatException e) {
                log.info((Object)e.getMessage());
                log.info((Object)("word1: " + word1 + ", word2:" + word2 + " @line:" + this.linesRead));
                throw e;
            }
        }
        return map;
    }

    @Override
    public void remove() {
    }
}

