/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import com.google.common.collect.HashMultimap;
import it.uniroma1.lcl.jlt.util.ChiScore;
import it.uniroma1.lcl.jlt.util.Counter;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.FormattedFileWriter;
import it.uniroma1.lcl.jlt.util.IntegerCounter;
import it.uniroma1.lcl.jlt.util.Maths;
import it.uniroma1.lcl.jlt.util.Pair;
import it.uniroma1.lcl.jlt.util.ScoredItem;
import it.uniroma1.lcl.jlt.util.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapCounter<K, V> {
    protected static Integer counterNo = 1;
    private Map<K, Map<V, Integer>> counter;
    private String name;

    public MapCounter(String name) {
        this.counter = new HashMap<K, Map<V, Integer>>();
        this.name = name;
    }

    public MapCounter() {
        Integer n = counterNo;
        counterNo = n + 1;
        this("MapCounter " + n);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void count(K k, V v) {
        this.count(k, v, 1);
    }

    public void remove(K k, V v) {
        Map<V, Integer> kMap = this.counter.get(k);
        if (kMap != null) {
            kMap.remove(v);
        }
    }

    public void count(K k, V v, int j) {
        Integer vCount;
        Map<Integer, Integer> kMap = this.counter.get(k);
        if (kMap == null) {
            kMap = new HashMap<V, Integer>();
            this.counter.put(k, kMap);
        }
        if ((vCount = kMap.get(v)) == null) {
            vCount = 0;
        }
        kMap.put((Integer)v, vCount + j);
    }

    public void addFrom(MapCounter<K, V> other) {
        for (K u : other.keySet()) {
            Map<V, Integer> otherMap = other.get(u);
            for (V v : otherMap.keySet()) {
                this.count(u, v, otherMap.get(v));
            }
        }
    }

    public int get(K k, V v) {
        Map<V, Integer> vMap = this.counter.get(k);
        if (vMap == null) {
            return 0;
        }
        Integer val = vMap.get(v);
        if (val == null) {
            return 0;
        }
        return val;
    }

    public Map<V, Integer> get(K k) {
        Map<V, Integer> vMap = this.counter.get(k);
        if (vMap == null) {
            return null;
        }
        return new HashMap<V, Integer>(vMap);
    }

    public List<ScoredItem<V>> getValuesSortedByCount(K k, boolean bNormalized) {
        Map<V, Integer> kMap = this.counter.get(k);
        if (kMap == null) {
            return null;
        }
        double total = this.getTotalCountByKey(k);
        HashMultimap valueByScore = new HashMultimap();
        for (V v : kMap.keySet()) {
            double score = kMap.get(v).intValue();
            if (bNormalized) {
                score /= total;
            }
            valueByScore.put((Object)score, new ScoredItem<V>(v, score));
        }
        ArrayList doubleList = new ArrayList(valueByScore.keySet());
        Collections.sort(doubleList);
        Collections.reverse(doubleList);
        ArrayList<ScoredItem<V>> scoredItems = new ArrayList<ScoredItem<V>>();
        for (Double score : doubleList) {
            scoredItems.addAll(valueByScore.get((Object)score));
        }
        return scoredItems;
    }

    public List<ScoredItem<V>> getValuesSortedByCount(K k) {
        return this.getValuesSortedByCount(k, true);
    }

    public ChiScore getChiSquareValue(K key1, MapCounter<K, V> counter2, K key2) {
        double score = 0.0;
        Map<V, Integer> v1 = this.counter.get(key1);
        Map<V, Integer> v2 = counter2.counter.get(key2);
        int tot1 = this.getTotalCountByKey(key1);
        int tot2 = counter2.getTotalCountByKey(key2);
        double tot = tot1 + tot2;
        HashSet<V> keys = new HashSet<V>(v1.keySet());
        keys.addAll(v2.keySet());
        for (Object val : keys) {
            Integer o2;
            Integer o1 = v1.get(val);
            if (o1 == null) {
                o1 = 0;
            }
            if ((o2 = v2.get(val)) == null) {
                o2 = 0;
            }
            Integer toto = o1 + o2;
            double e1 = (double)(tot1 * toto) / tot;
            double contrib1 = Math.pow((double)o1.intValue() - e1, 2.0) / e1;
            double e2 = (double)(tot2 * toto) / tot;
            double contrib2 = Math.pow((double)o2.intValue() - e2, 2.0) / e2;
            score += contrib1;
            score += contrib2;
            System.out.println("tot1=" + tot1 + ",tot2=" + tot2 + ",toto=" + toto + ",tot=" + tot);
            System.out.println("(" + o1 + "-" + e1 + ")^2/" + e1);
        }
        System.out.println("= " + score);
        return new ChiScore(score, keys.size() - 1);
    }

    public Set<K> keySet() {
        return this.counter.keySet();
    }

    public double getConditionalProbability(K k, V v) {
        Map<V, Integer> distrib = this.counter.get(k);
        if (distrib == null) {
            return 0.0;
        }
        Integer val = distrib.get(v);
        if (val == null) {
            return 0.0;
        }
        double total = 0.0;
        for (V w : distrib.keySet()) {
            total += (double)distrib.get(w).intValue();
        }
        return (double)val.intValue() / total;
    }

    public int getTotalCountByKey(K k) {
        Map<V, Integer> kMap = this.counter.get(k);
        if (kMap == null) {
            return 0;
        }
        int total = 0;
        for (Integer i : kMap.values()) {
            total += i.intValue();
        }
        return total;
    }

    public int getMinimumCountByKey(K k) {
        Map<V, Integer> kMap = this.counter.get(k);
        if (kMap == null) {
            return 0;
        }
        int min = Integer.MAX_VALUE;
        for (Integer i : kMap.values()) {
            if (min <= i) continue;
            min = i;
        }
        return min;
    }

    public int getMaximumCountByKey(K k) {
        Map<V, Integer> kMap = this.counter.get(k);
        if (kMap == null) {
            return 0;
        }
        int max = Integer.MIN_VALUE;
        for (Integer i : kMap.values()) {
            if (max >= i) continue;
            max = i;
        }
        return max;
    }

    public void resetCounts() {
        this.counter.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("=== MAP_COUNTER " + this.name + " ===\n");
        for (K k : this.counter.keySet()) {
            sb.append("\t" + k.toString() + ":" + this.counter.get(k) + "\n");
        }
        return sb.toString();
    }

    public String toFileString() {
        StringBuffer buffer = new StringBuffer();
        for (K key : this.counter.keySet()) {
            Map<V, Integer> counter2 = this.counter.get(key);
            ArrayList<String> words = new ArrayList<String>();
            for (V item : counter2.keySet()) {
                words.add(item + ":" + counter2.get(item));
            }
            buffer.append(key + "\t" + Strings.join(words, ",") + "\n");
        }
        return buffer.toString();
    }

    public static MapCounter<String, String> fromLineString(String line) {
        MapCounter<String, String> counter = new MapCounter<String, String>();
        Pair<String, String> pair = Strings.splitToPair(line, "\t");
        String word1 = pair.getFirst();
        String words = pair.getSecond();
        for (String wordCount2 : Strings.split(words, ",")) {
            String word2;
            int lastIndex = wordCount2.lastIndexOf(58);
            if (lastIndex == -1 || (word2 = wordCount2.substring(0, lastIndex)).isEmpty()) continue;
            try {
                counter.count(word1, word2, Integer.parseInt(wordCount2.substring(lastIndex + 1)));
            }
            catch (NumberFormatException e) {
                System.out.println(e.getMessage());
                System.out.println("word1: " + word1 + ", word2:" + word2 + " @line:" + line);
                throw e;
            }
        }
        return counter;
    }

    public void saveToFile(String filename) {
        this.saveToFile(filename, false);
    }

    public void saveToFile(String filename, boolean bAppend) {
        this.saveToFile(filename, bAppend, false);
    }

    public void saveToFile(String filename, boolean bAppend, boolean bSort) {
        this.saveToFile(filename, bAppend, bSort, null);
    }

    public void saveToFile(String filename, boolean bAppend, boolean bSort, Comparator<K> keysComparator) {
        FormattedFileWriter writer = new FormattedFileWriter(filename, "%s\t%s", bAppend, false);
        ArrayList<K> keys = new ArrayList<K>(this.counter.keySet());
        if (keysComparator != null) {
            Collections.sort(keys, keysComparator);
        }
        for (Object key : keys) {
            Map<V, Integer> counter2 = this.counter.get(key);
            List<Object> secondKeys = bSort ? new IntegerCounter<V>(counter2).getSortedElements() : new ArrayList<V>(counter2.keySet());
            ArrayList<String> words = new ArrayList<String>();
            for (Object secondKey : secondKeys) {
                words.add(secondKey + ":" + counter2.get(secondKey));
            }
            writer.write(key, Strings.join(words, ","));
        }
        writer.close();
    }

    public static MapCounter<String, String> loadFromFile(String filename) {
        MapCounter<String, String> counter = null;
        String line = null;
        try {
            BufferedReader reader = Files.getBufferedReader(filename);
            counter = new MapCounter<String, String>();
            int linesRead = 0;
            while (reader.ready()) {
                line = reader.readLine();
                ++linesRead;
                Pair<String, String> pair = Strings.splitToPair(line, "\t");
                String word1 = pair.getFirst();
                String words = pair.getSecond();
                for (String wordCount2 : Strings.split(words, ",")) {
                    String word2;
                    int lastIndex = wordCount2.lastIndexOf(58);
                    if (lastIndex == -1 || (word2 = wordCount2.substring(0, lastIndex)).isEmpty()) continue;
                    try {
                        counter.count(word1, word2, Integer.parseInt(wordCount2.substring(lastIndex + 1)));
                    }
                    catch (NumberFormatException e) {
                        System.out.println(e.getMessage());
                        System.out.println("word1: " + word1 + ", word2:" + word2 + " @line:" + linesRead);
                        throw e;
                    }
                }
            }
            reader.close();
        }
        catch (StringIndexOutOfBoundsException e) {
            System.out.println("Trying to load a map counter from file: " + filename + ":\n" + line);
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return counter;
    }

    public MapCounter<K, V> filter(Counter.CountThreshold threshold) {
        return this.filter(threshold, 0);
    }

    public MapCounter<K, V> filter(Counter.CountThreshold threshold, int k) {
        MapCounter filtered = new MapCounter(this.getName());
        for (K key : this.keySet()) {
            Counter counts = new IntegerCounter<V>(this.get(key));
            counts = counts.filter(threshold, k);
            for (Object subKey : counts.keySet()) {
                filtered.count(key, subKey, (Integer)counts.get(subKey));
            }
        }
        return filtered;
    }

    public MapCounter<K, V> filterMinSupport(int min) {
        MapCounter<K, V> filtered = new MapCounter<K, V>(this.getName());
        for (K key1 : this.keySet()) {
            for (V key2 : this.get(key1).keySet()) {
                int value = this.get(key1, key2);
                if (value >= min) {
                    filtered.count(key1, key2, value);
                    continue;
                }
                filtered.count(key1, key2, 0);
            }
        }
        return filtered;
    }

    public static void main(String[] args) {
        MapCounter<String, String> map = new MapCounter<String, String>();
        map.count("a", "b");
        map.count("a", "b");
        map.count("a", "c");
        map.count("a", "c");
        map.count("a", "c");
        map.count("a", "d");
        map.count("a", "d");
        map.count("a", "d");
        map.saveToFile("testT.txt", true);
        map.saveToFile("testTT.txt", true, true);
        map.saveToFile("testTF.txt", true, false);
        map.saveToFile("testTTT.txt", true, true, String.CASE_INSENSITIVE_ORDER);
        map.saveToFile("testTFT.txt", true, false, String.CASE_INSENSITIVE_ORDER);
        map.saveToFile("testTTF.txt", true, true, null);
        map.saveToFile("testTFF.txt", true, false, null);
        map.resetCounts();
        map.count("a", "d");
        map.count("b", "c");
        map.count("b", "c");
        map.count("b", "d");
        map.count("b", "d");
        map.count("b", "d");
        map.count("b", "d");
        map.count("b", "e");
        map.count("c", "a");
        map.count("c", "b");
        map.count("d", "b");
        map.count("d", "c");
        map.count("e", "f");
        map.saveToFile("testT.txt", true);
        map.saveToFile("testTT.txt", true, true);
        map.saveToFile("testTF.txt", true, false);
        map.saveToFile("testTTT.txt", true, true, String.CASE_INSENSITIVE_ORDER);
        map.saveToFile("testTFT.txt", true, false, String.CASE_INSENSITIVE_ORDER);
        map.saveToFile("testTTF.txt", true, true, null);
        map.saveToFile("testTFF.txt", true, false, null);
        map.saveToFile("testF.txt", false);
        map.saveToFile("testFT.txt", false, true);
        map.saveToFile("testFF.txt", false, false);
        map.saveToFile("testFTT.txt", false, true, String.CASE_INSENSITIVE_ORDER);
        map.saveToFile("testFFT.txt", false, false, String.CASE_INSENSITIVE_ORDER);
        map.saveToFile("testFTF.txt", false, true, null);
        map.saveToFile("testFFF.txt", false, false, null);
        map = MapCounter.loadFromFile("test.txt");
        System.out.println(map);
        MapCounter<String, String> lose = MapCounter.loadFromFile("/home/flati/resources/GraSP/GIGA/lo/lose#v/lose#v.lex_distr.clean");
        Map<String, Integer> wind = lose.get("wind#n");
        Map<String, Integer> lead = lose.get("lead#n");
        Map<String, Integer> storm = lose.get("storm#n");
        wind.remove("lose");
        lead.remove("lose");
        storm.remove("lose");
        System.out.println("wind-lead:" + Maths.cosineSimilarity(wind, lead));
        System.out.println("wind-storm:" + Maths.cosineSimilarity(wind, storm));
        System.out.println("storm-lead:" + Maths.cosineSimilarity(lead, storm));
        Maths.filterVector(wind, 3);
        Maths.filterVector(lead, 3);
        Maths.filterVector(storm, 3);
        System.out.println(wind);
        System.out.println(lead);
        System.out.println(storm);
        System.out.println("wind-lead:" + Maths.cosineSimilarity(wind, lead));
        System.out.println("wind-storm:" + Maths.cosineSimilarity(wind, storm));
        System.out.println("storm-lead:" + Maths.cosineSimilarity(lead, storm));
    }
}

