/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.Counter;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.Pair;
import it.uniroma1.lcl.jlt.util.Strings;
import java.io.BufferedReader;
import java.util.Collection;
import java.util.Map;

public class LongCounter<K>
extends Counter<K, Long> {
    public LongCounter(String name) {
        super(name);
    }

    public LongCounter() {
    }

    public LongCounter(Collection<K> collection) {
        super(collection);
    }

    public LongCounter(Map<K, Long> collection) {
        super(collection);
    }

    @Override
    public void count(K element) {
        this.count(element, 1L);
    }

    @Override
    public void count(K element, Long value) {
        Long oldCount = (Long)this.counter.get(element);
        if (oldCount == null) {
            oldCount = 0L;
        }
        this.counter.put(element, oldCount + value);
        this.total += (double)value.longValue();
    }

    @Override
    protected Long getNumber(String string) {
        return Long.parseLong(string);
    }

    @Override
    protected Counter<K, Long> getNewInstance(String name) {
        return new LongCounter<K>(name);
    }

    public static LongCounter<String> loadFromFile(String filename) {
        LongCounter<String> counter = null;
        try {
            BufferedReader reader = Files.getBufferedReader(filename);
            counter = new LongCounter<String>();
            while (reader.ready()) {
                String line = reader.readLine();
                Pair<String, String> pair = Strings.splitToPair(line, "\t");
                String word = pair.getFirst();
                String count = pair.getSecond();
                counter.count(word, Long.parseLong(count));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return counter;
    }
}

