/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRU<K, V> {
    private static final int DEFAULT_MAX_SIZE = 50;
    private final Map<K, V> cache;

    public LRU() {
        this(50);
    }

    public LRU(final int maxSize) {
        this.cache = new LinkedHashMap<K, V>(maxSize, 0.75f, true){
            private static final long serialVersionUID = 2261365681291752981L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > maxSize;
            }
        };
    }

    public V get(K k) {
        return this.cache.get(k);
    }

    public V put(K k, V v) {
        return this.cache.put(k, v);
    }
}

