/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.Lemmatizer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ItalianLemmatizer
extends Lemmatizer {
    private static HashMap<String, Set<String>> lemmaTable = null;

    public ItalianLemmatizer() throws IOException {
        if (lemmaTable == null) {
            lemmaTable = new HashMap();
            for (String file : Configuration.getInstance().getItalianLemmaTable()) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
                while ((line = br.readLine()) != null) {
                    String[] record = line.split("\t");
                    Set<String> lemmas = lemmaTable.get(record[0]);
                    if (lemmas == null) {
                        lemmas = new HashSet<String>();
                        lemmaTable.put(record[0], lemmas);
                    }
                    String pos = null;
                    switch (record[2].charAt(0)) {
                        case 'V': {
                            pos = "v";
                            break;
                        }
                        case 'N': {
                            pos = "n";
                            break;
                        }
                        case 'A': {
                            if (record[2].startsWith("ADJ")) {
                                pos = "a";
                                break;
                            }
                            if (!record[2].startsWith("ADV")) break;
                            pos = "r";
                        }
                    }
                    lemmas.add(String.valueOf(record[1]) + "#" + pos);
                }
            }
        }
    }

    @Override
    public Set<String> getLemmas(String word, String pos) {
        HashSet<String> returnLemmas = new HashSet<String>();
        Set<String> lemmas = lemmaTable.get(word);
        if (lemmas == null) {
            return null;
        }
        for (String l : lemmas) {
            if (pos != null && !l.endsWith("#" + pos)) continue;
            returnLemmas.add(l.substring(0, l.lastIndexOf(35)));
        }
        if (returnLemmas.size() == 0) {
            return null;
        }
        return returnLemmas;
    }

    public static void main(String[] args) throws IOException {
        ItalianLemmatizer l = new ItalianLemmatizer();
        System.out.println(l.getLemmas("perch&eacute;"));
        System.out.println(l.getLemmas("il"));
        System.out.println(((Lemmatizer)l).getLemmas("andai", "v"));
        System.out.println(((Lemmatizer)l).getLemmas("andata", "v"));
        System.out.println(((Lemmatizer)l).getLemmas("andata", "a"));
        System.out.println(((Lemmatizer)l).getLemmas("and&ograve;", "v"));
    }
}

