/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.Counter;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.Pair;
import it.uniroma1.lcl.jlt.util.Strings;
import java.io.BufferedReader;
import java.util.Collection;
import java.util.Map;

public class IntegerCounter<K>
extends Counter<K, Integer> {
    public IntegerCounter(String name) {
        super(name);
    }

    public IntegerCounter() {
    }

    public IntegerCounter(Collection<K> collection) {
        super(collection);
    }

    public IntegerCounter(Map<K, Integer> collection) {
        super(collection);
    }

    @Override
    public void count(K k) {
        this.count(k, 1);
    }

    @Override
    public void count(K k, Integer j) {
        Integer oldCount = (Integer)this.counter.get(k);
        if (oldCount == null) {
            oldCount = 0;
        }
        this.counter.put(k, oldCount + j);
        this.total += (double)j.intValue();
    }

    @Override
    protected Integer getNumber(String string) {
        return Integer.parseInt(string);
    }

    @Override
    protected Counter<K, Integer> getNewInstance(String name) {
        return new IntegerCounter<K>(name);
    }

    public static IntegerCounter<String> loadFromFile(String filename) {
        IntegerCounter<String> counter = null;
        try {
            BufferedReader reader = Files.getBufferedReader(filename);
            counter = new IntegerCounter<String>();
            while (reader.ready()) {
                String line = reader.readLine();
                Pair<String, String> pair = Strings.splitToPair(line, "\t");
                String word = pair.getFirst();
                String count = pair.getSecond();
                counter.count(word, Integer.parseInt(count));
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return counter;
    }
}

