/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import com.google.common.collect.HashMultimap;
import it.uniroma1.lcl.jlt.util.DoubleCounter;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.Pair;
import it.uniroma1.lcl.jlt.util.Strings;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexedDoubleMapCounter {
    private static final Log log = LogFactory.getLog(IndexedDoubleMapCounter.class);
    private HashMultimap<String, Long> keyPositions;
    private String filename;
    private RandomAccessFile reader;

    public IndexedDoubleMapCounter(String filename) {
        this(filename, true);
    }

    public IndexedDoubleMapCounter(String filename, boolean bIndexAtStart) {
        this.filename = filename;
        if (bIndexAtStart) {
            this.index();
        }
        try {
            this.reader = new RandomAccessFile(filename, "r");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void index() {
        log.info((Object)("Indexing " + this.filename + " double map counter..."));
        long bytes = 0L;
        this.keyPositions = new HashMultimap();
        try {
            BufferedReader reader = Files.getBufferedReader(this.filename);
            while (reader.ready()) {
                String line = reader.readLine();
                Pair<String, String> pair = Strings.splitToPair(line, "\t");
                String word1 = pair.getFirst();
                this.keyPositions.put((Object)word1, (Object)bytes);
                bytes += (long)(line.getBytes().length + 1);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info((Object)(String.valueOf(this.filename) + " indexed"));
    }

    public DoubleCounter<String> loadKey(String key) {
        DoubleCounter<String> vector = new DoubleCounter<String>(key);
        try {
            for (Long position : this.keyPositions.get((Object)key)) {
                this.reader.seek(position);
                String line = this.reader.readLine();
                Pair<String, String> pair = Strings.splitToPair(line, "\t");
                String words = pair.getSecond();
                for (String wordCount2 : Strings.split(words, ",")) {
                    int lastIndex;
                    String word2 = wordCount2.substring(0, lastIndex = wordCount2.lastIndexOf(58));
                    if (word2.isEmpty()) continue;
                    try {
                        vector.count(word2, Double.parseDouble(wordCount2.substring(lastIndex + 1)));
                    }
                    catch (NumberFormatException e) {
                        System.out.println(e.getMessage());
                        System.out.println("word: " + word2 + " @byte:" + position);
                        throw e;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return vector;
    }

    public Set<String> getKeys() {
        return this.keyPositions.keySet();
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String filename = "your/favorite/double/map/counter.txt";
        IndexedDoubleMapCounter mapCounter = new IndexedDoubleMapCounter(filename);
        Set<String> keys = mapCounter.getKeys();
        for (String key : keys) {
            if (!key.startsWith("column#n")) continue;
            System.out.println(mapCounter.loadKey(key));
        }
    }
}

