/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.Configuration;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class HtmlDecoder {
    private final Map<String, String> htmlEntities = new HashMap<String, String>();
    private static HtmlDecoder instance;

    private HtmlDecoder() {
        try {
            this.load();
        }
        catch (IOException ioe) {
            throw new RuntimeException("CANNOT INIT: " + ioe);
        }
    }

    public static synchronized HtmlDecoder getInstance() {
        if (instance == null) {
            instance = new HtmlDecoder();
        }
        return instance;
    }

    public String unescapeHTML(String source) {
        boolean continueLoop;
        int skip = 0;
        do {
            int j;
            continueLoop = false;
            int i = source.indexOf("&", skip);
            if (i <= -1 || (j = source.indexOf(";", i)) <= i) continue;
            String entityToLookFor = source.substring(i, j + 1);
            String value = this.htmlEntities.get(entityToLookFor);
            if (value != null) {
                source = String.valueOf(source.substring(0, i)) + value + source.substring(j + 1);
                continueLoop = true;
                continue;
            }
            if (value != null) continue;
            skip = i + 1;
            continueLoop = true;
        } while (continueLoop);
        return source;
    }

    private void load() throws IOException {
        String mapfile = Configuration.getInstance().getHtmlUtf8EncodeFile();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(mapfile), "UTF8"));
        while (in.ready()) {
            String line = in.readLine();
            String[] splittedLine = line.split("\t");
            if (splittedLine.length != 2) {
                System.out.println("ERROR:" + line);
                System.exit(0);
                continue;
            }
            this.htmlEntities.put(splittedLine[0], splittedLine[1]);
        }
        in.close();
    }
}

