/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;

public class HashingService {
    public static final int DEFAULT_HASHING_LENGTH = 2;
    public static final int DEFAULT_HASHING_LEVELS = 2;
    public static final String INFO_FILE = ".info";
    private String basedir;
    private int hashingLength;
    private int hashingLevels;

    public HashingService(String basedir) {
        this(basedir, 2, 2);
    }

    public HashingService(String basedir, int hashingLength, int hashingLevels) {
        this.basedir = Files.addFileSeparator(basedir);
        this.hashingLength = hashingLength;
        this.hashingLevels = hashingLevels;
        String infofile = String.valueOf(this.basedir) + INFO_FILE;
        if (!new File(infofile).exists()) {
            this.createInfoFile(this.basedir);
        } else {
            this.loadInfoFile(this.basedir);
        }
    }

    private void loadInfoFile(String basedir) {
        try {
            BufferedReader reader = Files.getBufferedReader(String.valueOf(basedir) + INFO_FILE);
            this.hashingLength = new Integer(reader.readLine());
            this.hashingLevels = new Integer(reader.readLine());
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createInfoFile(String basedir) {
        try {
            BufferedWriter writer = Files.getBufferedWriter(String.valueOf(basedir) + INFO_FILE);
            writer.write(String.valueOf(this.hashingLength) + "\n");
            writer.write(String.valueOf(this.hashingLevels) + "\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getFilePath(String file) {
        return Files.getFullPathWithAlphabeticalHashing(this.basedir, file, this.hashingLength, this.hashingLevels);
    }

    public String getBasedir() {
        return this.basedir;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ":\n" + "hashingLength = " + this.hashingLength + "\n" + "hashingLevels = " + this.hashingLevels;
    }

    public static void main(String[] args) {
        HashingService hashing1 = new HashingService("hashing1", 2, 5);
        HashingService hashing2 = new HashingService("hashing2");
        HashingService hashing3 = new HashingService("hashing1", 2, 5);
        System.out.println(hashing1);
        System.out.println(hashing2);
        System.out.println(hashing3);
        System.out.println(hashing1.getFilePath("ambarab\u00e0cicc\u00eccocc\u00f2"));
        System.out.println(hashing2.getFilePath("ambarab\u00e0cicc\u00eccocc\u00f2"));
    }
}

