/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.Language;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FunctionWords {
    private static final Log log = LogFactory.getLog(FunctionWords.class);
    private final Set<String> functionwords = new HashSet<String>();
    private static Map<Language, FunctionWords> instances = new HashMap<Language, FunctionWords>();

    public static synchronized FunctionWords getInstance() {
        return FunctionWords.getInstance(Language.EN);
    }

    public static synchronized FunctionWords getInstance(Language language) {
        FunctionWords instance = instances.get((Object)language);
        if (instance == null) {
            instance = new FunctionWords(language);
            instances.put(language, instance);
        }
        return instance;
    }

    private FunctionWords(Language language) {
        String fwFile = Configuration.getInstance().getFunctionwordsFile(language);
        try {
            this.load(fwFile);
        }
        catch (FileNotFoundException fnfe) {
            log.warn((Object)("No file: " + fwFile + ", loading empty list"));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot load: " + ioe);
        }
    }

    public void load(String functionfile) throws IOException {
        this.load(functionfile, null);
    }

    public void load(String functionfile, String prefix) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(functionfile));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("%")) continue;
            if (prefix != null) {
                this.functionwords.add(String.valueOf(prefix) + line);
                continue;
            }
            this.functionwords.add(line);
        }
        br.close();
    }

    public boolean isFunctionword(String w) {
        boolean bResult = false;
        for (String s : this.functionwords) {
            if (!w.equalsIgnoreCase(s)) continue;
            bResult = true;
            break;
        }
        return bResult;
    }

    public void clear() {
        this.functionwords.clear();
    }

    public Set<String> getFunctionWords() {
        return this.functionwords;
    }

    public static void main(String[] args) throws IOException {
        FunctionWords fwList = FunctionWords.getInstance();
        System.out.println("TESTING in spite of (language " + (Object)((Object)Language.EN) + "): " + fwList.isFunctionword("in spite of"));
        System.out.println("TESTING with (language " + (Object)((Object)Language.EN) + "): " + fwList.isFunctionword("with"));
        System.out.println("TESTING from (language " + (Object)((Object)Language.EN) + "): " + fwList.isFunctionword("from"));
        System.out.println("TESTING abominion (language " + (Object)((Object)Language.EN) + "): " + fwList.isFunctionword("abominion"));
    }
}

