/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.Files;
import java.io.BufferedWriter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormattedFileWriter {
    protected static final Log log = LogFactory.getLog(FormattedFileWriter.class);
    protected BufferedWriter lineWriter;
    protected String format;
    protected boolean flushOnWrite = false;

    public FormattedFileWriter(String filename, String format) {
        this(filename, format, false, false);
    }

    public FormattedFileWriter(String filename, String format, boolean bAppend) {
        this(filename, format, bAppend, false);
    }

    public FormattedFileWriter(String filename, String format, boolean bAppend, boolean bFlushOnWrite) {
        try {
            this.lineWriter = Files.getBufferedWriter(filename, bAppend);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.format = format;
        this.flushOnWrite = bFlushOnWrite;
    }

    public void write(Object ... args) {
        try {
            this.lineWriter.write(String.valueOf(String.format(this.format, args)) + "\n");
            if (this.flushOnWrite) {
                this.lineWriter.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.lineWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

