/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.SimpleFileReader;
import java.io.BufferedReader;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormattedFileReader
extends SimpleFileReader<List<String>> {
    protected static final Log log = LogFactory.getLog(FormattedFileReader.class);
    protected BufferedReader lineReader;
    protected Pattern lineFormat;
    List<String> results = null;

    public FormattedFileReader(String filename, COMMON_FORMATS format) {
        this(filename, format.toString());
    }

    public FormattedFileReader(String filename, String format) {
        super(filename);
        this.lineFormat = Pattern.compile(format);
    }

    @Override
    public boolean hasNext() {
        String line;
        while ((line = this.readLine()) != null && (this.results = this.findNextLine(line, this.lineFormat)).isEmpty()) {
        }
        return line != null && this.results != null;
    }

    @Override
    public List<String> next() {
        return this.results;
    }

    public static void main(String[] args) {
        FormattedFileReader reader = new FormattedFileReader("/home/flati/Scaricati/test/recordfiletest.txt", COMMON_FORMATS.PARAMETER_AND_VALUE);
        for (List fields : reader) {
            log.info((Object)("FIELDS: " + fields));
        }
    }

    public static enum COMMON_FORMATS {
        PARAMETER_AND_VALUE{

            public String toString() {
                return "\\s*([^\\s]+)\\s*=\\s*([^\\s]+)\\s*";
            }
        }
        ,
        TWO_COLUMNS{

            public String toString() {
                return "\\s*([^\\s]+)\\s+([^\\s]+)\\s*";
            }
        }
        ,
        TWO_COLUMNS_AND_VALUE{

            public String toString() {
                return "\\s*([^\\s]+)\\s+([^\\s]+)\\s+(\\d+(?:\\.\\d+)*)\\s*";
            }
        }
        ,
        THREE_COLUMNS{

            public String toString() {
                return "\\s*([^\\s]+)\\s+([^\\s]+)\\s+([^\\s]+)\\s*";
            }
        }
        ,
        MULTI_COLUMNS{

            public String toString() {
                return "\\s*([^\\s]+)\\s*";
            }
        };

    }
}

