/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.Runner;
import it.uniroma1.lcl.jlt.util.Strings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Files {
    public static void copy(File source, File target) throws IOException {
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(source);
            to = new FileOutputStream(target);
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void copy(String source, String target) throws IOException {
        Files.copy(new File(source), new File(target));
    }

    public static BufferedReader getBufferedReader(String filename) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        return br;
    }

    public static BufferedWriter getBufferedWriter(String filename) throws IOException {
        return Files.getBufferedWriter(filename, false, MakeDir.MKDIRS);
    }

    public static BufferedWriter getBufferedWriter(String filename, boolean bAppend) throws IOException {
        return Files.getBufferedWriter(filename, bAppend, MakeDir.MKDIRS);
    }

    public static BufferedWriter getBufferedWriter(String filename, boolean bAppend, MakeDir mkdirs) throws IOException {
        if (mkdirs == MakeDir.MKDIRS) {
            new File(Files.getFilePath(filename)).mkdirs();
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename, bAppend));
        return bw;
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (Files.isValidDirectory(files[i])) {
                    Files.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return path.delete();
    }

    public static String[] getExtensionSplit(String filename) {
        int dotPos = filename.lastIndexOf(".");
        String extension = filename.substring(dotPos);
        String extensionLess = filename.substring(0, dotPos);
        return new String[]{extensionLess, extension};
    }

    public static String removeExtension(String filename) {
        return Files.getExtensionSplit(filename)[0];
    }

    public static String addTimestamp(String filename) {
        String[] extensionSplit = Files.getExtensionSplit(filename);
        String timestamp = Strings.getTimestamp();
        return new StringBuffer().append(extensionSplit[0]).append("-").append(timestamp).append(extensionSplit[1]).toString();
    }

    public static String addFileSeparator(String path) {
        if (!path.endsWith(File.separator)) {
            return String.valueOf(path) + File.separator;
        }
        return path;
    }

    public static String[] getFilesWithExtension(String dir, final String extension) {
        ArrayList<String> files = new ArrayList<String>();
        String[] stringArray = new File(dir).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(extension);
            }
        });
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            files.add(String.valueOf(dir) + File.separator + file);
            ++n2;
        }
        return files.toArray(new String[files.size()]);
    }

    public static List<File> listFiles(File directory, FilenameFilter filter, boolean recurse) {
        File[] entries;
        ArrayList<File> files = new ArrayList<File>();
        File[] fileArray = entries = directory.listFiles();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            File entry = fileArray[n2];
            if (filter == null || filter.accept(directory, entry.getName())) {
                files.add(entry);
            }
            if (recurse && Files.isValidDirectory(entry)) {
                files.addAll(Files.listFiles(entry, filter, recurse));
            }
            ++n2;
        }
        return files;
    }

    public static List<File> listFiles(File directory, String regex) {
        return Files.listFiles(directory, regex, Integer.MAX_VALUE, true);
    }

    public static List<File> listFiles(File directory, String regex, int maxDepth) {
        return Files.listFiles(directory, regex, maxDepth, true);
    }

    public static List<File> listFiles(File directory, String regex, int maxDepth, boolean bAll) {
        ArrayList<File> files = new ArrayList<File>();
        Files.listFiles(files, directory, regex, 0, maxDepth, bAll);
        return files;
    }

    protected static void listFiles(List<File> files, File directory, String regex, int depth, int maxDepth, boolean bAll) {
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File entry = fileArray[n2];
            if ((bAll || depth == maxDepth) && entry.getName().matches(regex)) {
                files.add(entry);
            }
            if (depth < maxDepth && Files.isValidDirectory(entry)) {
                Files.listFiles(files, entry, regex, depth + 1, maxDepth, bAll);
            }
            ++n2;
        }
    }

    public static String getFileName(String fullName) {
        return Strings.suffixUntil(fullName, File.separatorChar);
    }

    public static String getFileNameWithoutExtension(String fullName) {
        String fileName = Files.getFileName(fullName);
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static String getBaseDir(String fullName) {
        if (fullName.equals(File.separator)) {
            return fullName;
        }
        return Strings.prefixUntilLast(fullName.endsWith(File.separator) ? Strings.prefixOf(fullName, fullName.length() - 1) : fullName, File.separator);
    }

    public static String getFileNameExtension(String fullName) {
        String fileName = Files.getFileName(fullName);
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static String getFilePath(String fullName) {
        String path = Strings.prefixUntilLast(fullName, File.separatorChar);
        if (path.length() == fullName.length()) {
            return "";
        }
        return path;
    }

    public static boolean isValidDirectory(File aDirectory) {
        if (aDirectory == null) {
            return false;
        }
        if (!aDirectory.exists()) {
            return false;
        }
        if (!aDirectory.isDirectory()) {
            return false;
        }
        return aDirectory.canRead();
    }

    public static boolean isDirectoryEmpty(File aDirectory) {
        if (!aDirectory.exists()) {
            return true;
        }
        if (aDirectory.isDirectory()) {
            String[] files = aDirectory.list();
            return files.length == 0;
        }
        return false;
    }

    public static String getFullPathWithAlphabeticalHashing(String basepath, String filename) {
        return Files.getFullPathWithAlphabeticalHashing(basepath, filename, 2);
    }

    public static String getFullPathWithAlphabeticalHashing(String basepath, String filename, int hashingLength) {
        String bucket = Strings.prefixOf(filename, hashingLength);
        return String.valueOf(Files.addFileSeparator(basepath)) + bucket + File.separator + filename;
    }

    public static String getFullPathWithAlphabeticalHashing(String basepath, String filename, int hashingLength, int hashingLevels) {
        return String.valueOf(Files.addFileSeparator(basepath)) + Files.getFullPathWithAlphabeticalHashing(filename, hashingLength, Math.min(hashingLevels, filename.length() / hashingLength), filename);
    }

    private static String getFullPathWithAlphabeticalHashing(String filename, int hashingLength, int hashingLevels, String remainder) {
        if (hashingLevels == 0) {
            return filename;
        }
        String bucket = Strings.prefixOf(remainder, hashingLength);
        return String.valueOf(bucket) + File.separator + Files.getFullPathWithAlphabeticalHashing(filename, hashingLength, hashingLevels - 1, remainder.substring(hashingLength));
    }

    public static void writeOneLinePerDataItem(Collection<?> items, String filename) {
        Files.writeOneLinePerDataItem(items, filename, false);
    }

    public static void writeOneLinePerDataItem(Collection<?> items, String filename, boolean bAppend) {
        try {
            BufferedWriter writer = Files.getBufferedWriter(filename, bAppend);
            for (Object item : items) {
                writer.write(item + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to write out to file " + filename);
        }
    }

    public static List<String> readOneLinePerDataItem(String filename) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            BufferedReader reader = Files.getBufferedReader(filename);
            String line = "";
            while ((line = reader.readLine()) != null) {
                lines.add(line.trim());
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to read from file " + filename);
        }
        return lines;
    }

    public static int getFileLinesNumber(String file) {
        int total = 0;
        try {
            total = new Integer(Runner.getInstance().run("wc", "-l", file).split("\\s+")[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return total;
    }

    public static void main(String[] args) {
        try {
            System.out.println(Files.getFileName("/data/pippo"));
            System.out.println(Files.getFilePath("/data/pippo"));
            System.out.println(Files.getFullPathWithAlphabeticalHashing("/data/pippo", "word1.txt"));
            System.out.println(Files.getFullPathWithAlphabeticalHashing("/data/pippo/", "word1.txt"));
            System.out.println(Files.getFullPathWithAlphabeticalHashing("/data/pippo", "a"));
            System.out.println(Files.getFullPathWithAlphabeticalHashing("/data/pippo", "abcdefghilmnopqrstuvz", 2, 4));
            System.out.println(Files.getFullPathWithAlphabeticalHashing("/data/pippo", "abcdefghilmnopqrstuvz", 3, 4));
            System.out.println(Files.getFullPathWithAlphabeticalHashing("/data/pippo", "abcdefghilmnopqrstuvz", 10, 4));
            System.out.println(Files.getFullPathWithAlphabeticalHashing("/data/pippo", "abcdefghilmnopqrstuvz", 2, 15));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static enum MakeDir {
        MKDIRS,
        NONE;

    }
}

