/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import edu.mit.jwi.item.POS;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.Lemmatizer;
import it.uniroma1.lcl.jlt.util.Sets;
import it.uniroma1.lcl.jlt.util.Strings;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class EnglishLemmatizer
extends Lemmatizer {
    private static HashMap<String, Set<String>> lemmaTable = null;
    static String[] nounSuffixes = new String[]{"s", "ses", "xes", "zes", "ches", "shes", "men", "ies"};
    static String[] verbSuffixes = new String[]{"s", "ies", "es", "es", "ed", "ed", "ing", "ing"};
    static String[] adjSuffixes = new String[]{"er", "est", "er", "est"};
    static String[] nounEndings = new String[]{"", "s", "x", "z", "ch", "sh", "man", "y"};
    static String[] verbEndings = new String[]{"", "y", "e", "", "e", "", "e", ""};
    static String[] adjEndings = new String[]{"", "y", "e", "", "e", "", "e", ""};
    static Set<String> prepositions = new HashSet<String>();
    static String[] prepositionsArray;

    static {
        String[] stringArray = prepositionsArray = new String[]{"to", "at", "of", "on", "off", "in", "out", "up", "down", "from", "with", "into", "for", "about", "between"};
        int n = prepositionsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            prepositions.add(p);
            ++n2;
        }
    }

    public EnglishLemmatizer() throws IOException {
        if (lemmaTable == null) {
            lemmaTable = new HashMap();
            for (String file : Configuration.getInstance().getEnglishLemmaTable()) {
                String line;
                String pos = "n";
                if (file.indexOf("noun") != -1) {
                    pos = "n";
                } else if (file.indexOf("verb") != -1) {
                    pos = "v";
                } else if (file.indexOf("adj") != -1) {
                    pos = "a";
                } else if (file.indexOf("adv") != -1) {
                    pos = "r";
                }
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
                while ((line = br.readLine()) != null) {
                    String[] record = line.split(" ");
                    Set<String> lemmas = lemmaTable.get(String.valueOf(record[0]) + "#" + pos);
                    if (lemmas == null) {
                        lemmas = new HashSet<String>();
                        String thisPos = pos;
                        if (record.length > 2) {
                            thisPos = record[2];
                        }
                        lemmaTable.put(String.valueOf(record[0]) + "#" + thisPos, lemmas);
                    }
                    lemmas.add(record[1]);
                }
            }
        }
    }

    @Override
    public Set<String> getLemmas(String word) {
        HashSet<String> lemmas = new HashSet<String>();
        String[] stringArray = new String[]{"n", "v", "a", "r"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pos = stringArray[n2];
            Set<String> res = this.getLemmas(word, pos);
            if (res != null) {
                lemmas.addAll(res);
            }
            ++n2;
        }
        return lemmas;
    }

    public Set<String> getLemmasWithPos(String word) {
        HashSet<String> lemmaposes = new HashSet<String>();
        String[] stringArray = new String[]{"n", "v", "a", "r"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pos = stringArray[n2];
            Set<String> res = this.getLemmas(word, pos);
            if (res != null) {
                for (String re : res) {
                    lemmaposes.add(String.valueOf(re) + "#" + pos);
                }
            }
            ++n2;
        }
        return lemmaposes;
    }

    @Override
    public Set<String> getLemmas(String word, String pos) {
        Set<String> exceptions = lemmaTable.get(word = word.toLowerCase().replace(' ', '_'));
        if (exceptions != null) {
            return exceptions;
        }
        HashSet<String> lemmas = new HashSet<String>();
        int wordCount = Strings.count(word, '_') + 1;
        boolean bVerb = pos.equals("v");
        String lemma = this.getWordNetLemma(word, pos);
        if (lemma != null) {
            lemmas.add(lemma);
            if (!lemma.equals(word)) {
                return lemmas;
            }
        }
        if (wordCount > 2 && this.hasPrep(word)) {
            lemmas.add(this.getVerbPrepLemma(word));
            return lemmas;
        }
        StringBuffer sb = new StringBuffer();
        int position = 0;
        String[] parts = word.split("[-_]");
        int k = 0;
        while (k < parts.length) {
            String wordk = parts[k];
            if (bVerb || k == parts.length - 1) {
                String base = this.getWordNetLemma(wordk, pos, true);
                if (base != null) {
                    sb.append(base);
                } else {
                    sb.append(wordk);
                }
            } else {
                sb.append(wordk);
            }
            position += wordk.length();
            if (k < parts.length - 1) {
                sb.append(word.charAt(position));
            }
            ++position;
            ++k;
        }
        if (!sb.toString().equals(word) && this.isDefined(sb.toString(), pos)) {
            lemmas.add(sb.toString());
            return lemmas;
        }
        return Sets.varargsToHashSet(sb.toString());
    }

    public String getVerbPrepLemma(String word) {
        String lemma;
        String lemma2;
        String[] parts = word.split("_");
        int startIdx = 1;
        int endIdx = parts.length - 1;
        String end = "";
        if (parts.length >= 2 && (lemma2 = this.getWordNetLemma(parts[parts.length - 1], "n")) != null) {
            --endIdx;
            end = lemma2;
        }
        String verb = parts[0];
        int k = 0;
        while (k < verb.length()) {
            if (!Character.isLetterOrDigit(verb.charAt(k))) {
                return null;
            }
            ++k;
        }
        Set<String> exceptions = lemmaTable.get(String.valueOf(verb) + "#v");
        if (exceptions != null && !verb.equals(lemma = exceptions.iterator().next())) {
            String newLemma = String.valueOf(verb) + "_" + Strings.join(parts, startIdx, endIdx, "_");
            if (this.isDefined(newLemma, "v")) {
                return newLemma;
            }
            if (end.length() > 0 && this.isDefined(newLemma = String.valueOf(verb) + "_" + end, "v")) {
                return newLemma;
            }
        }
        int k2 = 0;
        while (k2 < verbSuffixes.length) {
            String base;
            if (verb.endsWith(verbSuffixes[k2]) && !(base = String.valueOf(verb.substring(0, verb.length() - verbSuffixes[k2].length())) + verbEndings[k2]).equals(verb)) {
                String newLemma = String.valueOf(base) + "_" + Strings.join(parts, startIdx, endIdx, "_");
                if (this.isDefined(newLemma, "v")) {
                    return newLemma;
                }
                if (end.length() > 0 && this.isDefined(newLemma = String.valueOf(base) + "_" + end, "v")) {
                    return newLemma;
                }
            }
            ++k2;
        }
        String newLemma = String.valueOf(verb) + "_" + Strings.join(parts, startIdx, endIdx, "_");
        if (!newLemma.equals(word)) {
            return newLemma;
        }
        if (end.length() > 0 && !(newLemma = String.valueOf(verb) + "_" + end).equals(word)) {
            return newLemma;
        }
        return "";
    }

    public String getWordNetLemma(String word, String pos) {
        return this.getWordNetLemma(word, pos, false);
    }

    private String getWordNetLemma(String word, String pos, boolean bSingularOnly) {
        Set<String> exceptions = lemmaTable.get(String.valueOf(word) + "#" + pos);
        if (bSingularOnly && exceptions != null) {
            return exceptions.iterator().next();
        }
        String end = "";
        if (pos.equals("r")) {
            return null;
        }
        if (pos.equals("n")) {
            if (word.endsWith("ful")) {
                word = word.substring(0, word.length() - 3);
                end = "ful";
            } else if (word.endsWith("ss") || word.length() <= 2) {
                return null;
            }
        }
        String[] suffixes = null;
        String[] endings = null;
        if (pos.equals("n")) {
            suffixes = nounSuffixes;
            endings = nounEndings;
        } else if (pos.equals("a")) {
            suffixes = adjSuffixes;
            endings = adjEndings;
        } else if (pos.equals("v")) {
            suffixes = verbSuffixes;
            endings = verbEndings;
        }
        if (!bSingularOnly && this.isDefined(word, pos)) {
            return word;
        }
        int k = 0;
        while (k < suffixes.length) {
            String base;
            if (word.endsWith(suffixes[k]) && this.isDefined(base = String.valueOf(word.substring(0, word.length() - suffixes[k].length())) + endings[k], pos)) {
                return String.valueOf(base) + end;
            }
            ++k;
        }
        return null;
    }

    public boolean isDefined(String word, String pos) {
        POS p = POS.NOUN;
        if (pos.equals("n")) {
            p = POS.NOUN;
        } else if (pos.equals("a")) {
            p = POS.ADJECTIVE;
        } else if (pos.equals("v")) {
            p = POS.VERB;
        } else if (pos.equals("r")) {
            p = POS.ADVERB;
        }
        return WordNet.getInstance().getSenses(word, p).size() > 0;
    }

    public boolean hasPrep(String word) {
        String[] parts = word.split("_");
        int k = 1;
        while (k < parts.length) {
            if (prepositions.contains(parts[k])) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public static void main(String[] args) throws IOException {
        EnglishLemmatizer el = new EnglishLemmatizer();
        System.out.println(el.getLemmas("saw", "v"));
        System.out.println(el.getLemmas("arms", "n"));
        System.out.println(el.getLemmas("saw", "n"));
        System.out.println(el.getLemmas("bus_arms", "n"));
        System.out.println(el.getWordNetLemma("headscarve", "n"));
        System.out.println(el.getWordNetLemma("buses_driver", "n"));
        System.out.println(el.getWordNetLemma("bus_drivers", "n"));
        System.out.println(el.getWordNetLemma("buses_drivers", "n"));
        System.out.println(el.getLemmas("doing", "v"));
        System.out.println(el.getLemmas("doing", "v"));
        System.out.println(el.getLemmas("done", "v"));
        System.out.println(el.getLemmas("babies", "n"));
        System.out.println(el.getLemmas("churches", "n"));
        System.out.println(el.getLemmas("dizzier", "a"));
        System.out.println(el.getLemmas("taxi driver", "n"));
        System.out.println(el.getLemmas("went away", "v"));
        System.out.println(el.getLemmas("go away", "v"));
        System.out.println(el.getLemmas("apple companies", "n"));
        System.out.println(el.getLemmas("apple company", "n"));
        System.out.println(el.getLemmas("kilos kilos", "n"));
        System.out.println(el.getLemmas("buses driver", "n"));
        System.out.println(el.getLemmas("buses drivers", "n"));
        System.out.println(el.getLemmas("bus drivers", "n"));
        System.out.println(el.getLemmas("went", "v"));
        System.out.println(el.getLemmas("did", "v"));
        System.out.println(el.getLemmas("talked", "v"));
    }
}

