/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.Counter;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.Pair;
import it.uniroma1.lcl.jlt.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.util.Collection;
import java.util.Map;

public class DoubleCounter<K>
extends Counter<K, Double> {
    public DoubleCounter(String name) {
        super(name);
    }

    public DoubleCounter() {
    }

    public DoubleCounter(Collection<K> collection) {
        super(collection);
    }

    public DoubleCounter(Map<K, Double> collection) {
        super(collection);
    }

    @Override
    public void count(K element) {
        this.count(element, 1.0);
    }

    @Override
    public void count(K element, Double value) {
        Double oldCount = (Double)this.counter.get(element);
        if (oldCount == null) {
            oldCount = 0.0;
        }
        this.counter.put(element, oldCount + value);
        this.total += value.doubleValue();
    }

    @Override
    protected Double getNumber(String string) {
        return Double.parseDouble(string);
    }

    @Override
    protected Counter<K, Double> getNewInstance(String name) {
        return new DoubleCounter<K>(name);
    }

    public static DoubleCounter<String> loadFromFile(String filename) {
        DoubleCounter<String> counter;
        block4: {
            counter = null;
            if (new File(filename).exists()) break block4;
            return null;
        }
        try {
            BufferedReader reader = Files.getBufferedReader(filename);
            counter = new DoubleCounter<String>();
            while (reader.ready()) {
                String line = reader.readLine();
                Pair<String, String> pair = Strings.splitToPair(line, "\t");
                String word = pair.getFirst();
                String count = pair.getSecond();
                counter.count(word, Double.parseDouble(count));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return counter;
    }

    public void normalizeBy(double k) {
        if (k <= 0.0) {
            return;
        }
        if (this.total == 0.0) {
            return;
        }
        for (Object element : this.counter.keySet()) {
            this.counter.put(element, (Double)this.counter.get(element) / k);
        }
        this.total /= k;
    }

    public void normalizeByMaximum() {
        if (this.total == 0.0) {
            return;
        }
        double max = 0.0;
        max = (Double)this.getTopValue();
        for (Object element : this.counter.keySet()) {
            this.counter.put(element, (Double)this.counter.get(element) / max);
        }
        this.total = 1.0;
    }

    public static void main(String[] args) {
        DoubleCounter<String> counter = new DoubleCounter<String>();
        counter.count("A", 5.0);
        counter.count("A", 2.0);
        counter.count("A", 5.0);
        counter.count("A", 1.0);
        counter.count("B", 10.0);
        counter.count("C", 15.0);
        System.out.println(counter);
        System.out.println(">15\n" + counter.filter(Counter.CountThreshold.ABSOLUTE, 15.0));
        System.out.println(">14\n" + counter.filter(Counter.CountThreshold.ABSOLUTE, 14.0));
        System.out.println(">10\n" + counter.filter(Counter.CountThreshold.ABSOLUTE, 10.0));
        System.out.println(">5\n" + counter.filter(Counter.CountThreshold.ABSOLUTE, 5.0));
    }
}

