/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DirectoryFileManager {
    private static final String SUBDIR_PREFIX = "dir_";
    private final File baseDir;
    private final int maxFilesPerDir;
    private int currentSubdirectoryIndex;
    private File currentSubdirectory;
    private int currentSubdirectorySize;
    private final Map<String, File> filename2subdirectory;

    public DirectoryFileManager(String baseDir, int maxFilesPerDir) {
        this(new File(baseDir), maxFilesPerDir);
    }

    public DirectoryFileManager(File baseDir, int maxFilesPerDir) {
        this.baseDir = baseDir;
        this.maxFilesPerDir = maxFilesPerDir;
        this.filename2subdirectory = new HashMap<String, File>();
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        this.initNextSubdirectory();
    }

    private void initNextSubdirectory() {
        ++this.currentSubdirectoryIndex;
        this.currentSubdirectory = new File(this.baseDir, SUBDIR_PREFIX + this.currentSubdirectoryIndex);
        if (!this.currentSubdirectory.exists()) {
            this.currentSubdirectory.mkdirs();
        }
        this.currentSubdirectorySize = 0;
    }

    public synchronized FileWriter getFileWriter(String filename) throws IOException {
        if (this.currentSubdirectorySize == this.maxFilesPerDir) {
            this.initNextSubdirectory();
        }
        FileWriter writer = new FileWriter(new File(this.currentSubdirectory, filename));
        this.filename2subdirectory.put(filename, this.currentSubdirectory);
        ++this.currentSubdirectorySize;
        return writer;
    }

    public FileWriter getAppendedFileWriter(String filename) throws IOException {
        if (this.filename2subdirectory.containsKey(filename)) {
            return new FileWriter(new File(this.filename2subdirectory.get(filename), filename), true);
        }
        return this.getFileWriter(filename);
    }

    public static void main(String[] args) {
        try {
            File testDir = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "DirectoryFileManager-Test");
            DirectoryFileManager manager = new DirectoryFileManager(testDir, 100);
            int i = 0;
            while (i < 1000) {
                String filename = String.valueOf(new Integer(i).toString()) + ".txt";
                FileWriter writer = manager.getFileWriter(filename);
                writer.write("Hello, World!");
                writer.close();
                ++i;
            }
            FileWriter writer = manager.getAppendedFileWriter("64.txt");
            writer.write("\nHello, Appended World!");
            writer.close();
            Files.deleteDirectory(testDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

