/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Dataset {
    protected final Log log = LogFactory.getLog(this.getClass());

    protected Dataset(String ... files) {
        String whoami = this.getClass().getSimpleName();
        this.log.info((Object)("Loading: " + whoami));
        long mem0 = this.usedMemory();
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            this.log.info((Object)("Loading file: " + file));
            this.load(file);
            ++n2;
        }
        long mem1 = this.usedMemory();
        double memDiff = (mem1 - mem0) / 0x100000L;
        this.log.info((Object)(String.valueOf(whoami) + " loaded -- memory consumption: +" + memDiff + "MB"));
    }

    protected void load(String file) {
        this.init();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.getEncoding()));
            while (br.ready()) {
                this.put(br.readLine());
            }
            br.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected String getEncoding() {
        return "UTF-8";
    }

    protected abstract void init();

    protected abstract void put(String var1);

    private long usedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }
}

