/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.FormattedFileWriter;
import it.uniroma1.lcl.jlt.util.Maps;
import it.uniroma1.lcl.jlt.util.Maths;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Counter<K, V extends Number>
implements Serializable {
    private static final long serialVersionUID = -4457175466627881184L;
    private static Integer counterId = 1;
    private final String name;
    protected final Map<K, V> counter;
    protected double total;

    public Counter(String name) {
        this.name = name;
        this.counter = new HashMap();
        this.total = 0.0;
    }

    public Counter() {
        Integer n = counterId;
        counterId = n + 1;
        this("Counter " + n);
    }

    public Counter(Collection<K> collection) {
        this();
        for (K k : collection) {
            this.count(k);
        }
    }

    public Counter(Map<K, V> collection) {
        this();
        for (K k : collection.keySet()) {
            this.count(k, (Number)collection.get(k));
        }
    }

    public abstract void count(K var1);

    public abstract void count(K var1, V var2);

    protected abstract V getNumber(String var1);

    protected abstract Counter<K, V> getNewInstance(String var1);

    public void addFrom(Map<K, V> counter2) {
        for (K element : counter2.keySet()) {
            this.count(element, (Number)counter2.get(element));
        }
    }

    public void addFrom(Counter<K, V> counter2) {
        for (K element : counter2.counter.keySet()) {
            this.count(element, (Number)counter2.counter.get(element));
        }
    }

    public void addFrom(Counter<K, V> counter2, CompositionalMode mode) {
        this.addFrom(counter2.getMap(), mode);
    }

    public void addFrom(Map<K, V> counter2, CompositionalMode mode) {
        if (this.size() == 0) {
            mode = CompositionalMode.ADDITIVE;
        }
        switch (mode) {
            case ADDITIVE: {
                for (K element : counter2.keySet()) {
                    this.count(element, (Number)counter2.get(element));
                }
                break;
            }
            case MULTIPLICATIVE: {
                HashSet<K> setMinus = new HashSet<K>(this.keySet());
                setMinus.removeAll(counter2.keySet());
                HashSet<K> intersection = new HashSet<K>(this.keySet());
                intersection.removeAll(setMinus);
                for (Object element : setMinus) {
                    this.remove(element);
                }
                for (Object element : intersection) {
                    this.count(element, (Number)counter2.get(element));
                }
                break;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Set<K> keySet() {
        return this.counter.keySet();
    }

    public V get(K key) {
        Number val = (Number)this.counter.get(key);
        if (val != null) {
            return (V)val;
        }
        return this.getNumber("0");
    }

    public double getProbability(K key) {
        if (this.total == 0.0) {
            return 0.0;
        }
        V val = this.get(key);
        return ((Number)val).doubleValue() / this.total;
    }

    public double getTotal() {
        return this.total;
    }

    public Map<K, V> getMap() {
        return this.counter;
    }

    public int size() {
        return this.counter.size();
    }

    public void remove(K key) {
        if (this.counter.keySet().contains(key)) {
            Number count = (Number)this.counter.get(key);
            this.total -= count.doubleValue();
            this.counter.remove(key);
        }
    }

    public void clear() {
        this.counter.clear();
        this.total = 0.0;
    }

    public void reset(K element, V value) {
        Number vCount = (Number)this.counter.get(element);
        if (vCount != null) {
            this.total -= vCount.doubleValue();
        }
        this.counter.put(element, value);
        this.total += ((Number)value).doubleValue();
    }

    public double getLaplaceSmoothingProbability(K k) {
        return this.getLidstoneSmoothingProbability(k, 1.0, this.counter.keySet().size());
    }

    public double getLidstoneSmoothingProbability(K k, double lambda) {
        return this.getLidstoneSmoothingProbability(k, lambda, this.counter.keySet().size());
    }

    public double getLidstoneSmoothingProbability(K k, double lambda, int maximumItems) {
        double val = ((Number)this.get(k)).doubleValue();
        double numerator = val + lambda;
        double denominator = this.total + lambda * (double)maximumItems;
        return numerator / denominator;
    }

    public Counter<K, V> filter(CountThreshold threshold) {
        return this.filter(threshold, 0.0);
    }

    public Counter<K, V> filter(CountThreshold threshold, double k) {
        double thresholdValue = 0.0;
        switch (threshold) {
            case MEAN: {
                thresholdValue = Maths.mean(this.getValues());
                break;
            }
            case MEAN_MINUS_STD: {
                thresholdValue = Maths.mean(this.getValues()) - Maths.stddeviation(this.getValues());
                break;
            }
            case MEAN_PLUS_STD: {
                thresholdValue = Maths.mean(this.getValues()) + Maths.stddeviation(this.getValues());
                break;
            }
            case ABSOLUTE: {
                thresholdValue = k;
                break;
            }
            case TOP_SCORED: {
                thresholdValue = ((Number)this.getTopValue()).doubleValue();
            }
        }
        return this.keepItemsHigherThan(thresholdValue, true);
    }

    public Counter<K, V> keepItemsHigherThan(double threshold) {
        return this.keepItemsHigherThan(threshold, true);
    }

    public Counter<K, V> keepItemsHigherThan(double threshold, boolean strictlyHigher) {
        Counter<K, V> result = this.getNewInstance(this.name);
        for (K element : this.getSortedElements()) {
            V value = this.get(element);
            double doubleValue = ((Number)value).doubleValue();
            if (strictlyHigher && doubleValue <= threshold || !strictlyHigher && doubleValue < threshold) break;
            result.count(element, value);
        }
        return result;
    }

    public List<V> getValues() {
        return new ArrayList<V>(this.counter.values());
    }

    public List<V> getValues(Collection<K> items) {
        ArrayList<V> values = new ArrayList<V>();
        for (K item : items) {
            values.add(this.get(item));
        }
        return values;
    }

    public List<V> getSortedValues() {
        Map<K, V> sortByValue = Maps.sortByValue(this.counter, Maps.SortingOrder.DESCENDING);
        return new ArrayList<V>(sortByValue.values());
    }

    public List<K> getElements() {
        return new ArrayList<K>(this.counter.keySet());
    }

    public List<K> getSortedElements() {
        Map<K, V> sortedMap = Maps.sortByValue(this.counter, Maps.SortingOrder.DESCENDING);
        return new ArrayList<K>(sortedMap.keySet());
    }

    public List<K> getSortedElements(Collection<K> selection) {
        ArrayList<K> list = new ArrayList<K>();
        for (K element : this.getSortedElements()) {
            if (!selection.contains(element)) continue;
            list.add(element);
        }
        return list;
    }

    public List<K> getTopK(int topK) {
        ArrayList<K> list = new ArrayList<K>();
        int k = 0;
        for (K element : this.getSortedElements()) {
            list.add(element);
            if (++k >= topK) break;
        }
        return list;
    }

    public Counter<K, V> getTopKCounter(int topK) {
        return this.getProjection(this.getTopK(topK));
    }

    public K getTop() {
        if (this.size() == 0) {
            return null;
        }
        return this.getTopK(1).get(0);
    }

    public K getBottom() {
        if (this.size() == 0) {
            return null;
        }
        List<K> sortedElements = this.getSortedElements();
        return sortedElements.get(sortedElements.size() - 1);
    }

    public V getBottomValue() {
        if (this.size() == 0) {
            return null;
        }
        List<V> values = this.getSortedValues();
        return (V)((Number)values.get(values.size() - 1));
    }

    public List<K> getBottoms() {
        ArrayList<K> list = new ArrayList<K>();
        V bottom = this.getBottomValue();
        List<K> elements = this.getSortedElements();
        Collections.reverse(elements);
        for (K element : elements) {
            if (!this.get(element).equals(bottom)) break;
            list.add(element);
        }
        return list;
    }

    public List<K> getTops() {
        ArrayList<K> list = new ArrayList<K>();
        V top = this.getTopValue();
        for (K element : this.getSortedElements()) {
            if (!this.get(element).equals(top)) break;
            list.add(element);
        }
        return list;
    }

    public V getTopValue() {
        return this.get(this.getTop());
    }

    public List<K> getMinimumSupport(V lowerBound) {
        return this.getTopKMinimumSupport(this.size(), lowerBound);
    }

    public List<K> getTopKMinimumSupport(int topK, V lowerBound) {
        ArrayList<K> list = new ArrayList<K>();
        for (K element : this.getTopK(topK)) {
            if (((Comparable)this.get(element)).compareTo(lowerBound) < 0) continue;
            list.add(element);
        }
        return list;
    }

    public String toLineString() {
        return this.toLineString("/", " ");
    }

    public String toLineString(String keyValueSeparator, String fieldsSeparator) {
        StringBuffer sb = new StringBuffer();
        Map<K, V> sortedCounter = Maps.sortByValue(this.counter, Maps.SortingOrder.DESCENDING);
        for (K key : sortedCounter.keySet()) {
            sb.append(key.toString()).append(keyValueSeparator).append(sortedCounter.get(key)).append(fieldsSeparator);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("=== COUNTER  ").append(this.name).append(" ===\n");
        Map<K, V> sortedCounter = Maps.sortByValue(this.counter, Maps.SortingOrder.DESCENDING);
        for (K key : sortedCounter.keySet()) {
            sb.append("\t").append(key.toString()).append(": ").append(sortedCounter.get(key)).append("\n");
        }
        return sb.toString();
    }

    public void saveToFile(String filename) {
        this.saveToFile(filename, false, false);
    }

    public void saveToFile(String filename, boolean sorted, boolean bAppend) {
        FormattedFileWriter writer = new FormattedFileWriter(filename, "%s\t%s", bAppend, false);
        Collection<K> keyset = sorted ? this.getSortedElements() : this.counter.keySet();
        for (K key : keyset) {
            writer.write(key, this.counter.get(key));
        }
        writer.close();
    }

    public Counter<K, V> getProjection(Collection<K> selection) {
        Counter filtered = this.getNewInstance(this.getName());
        HashSet<K> keys = new HashSet<K>(this.keySet());
        keys.retainAll(selection);
        for (Object key : keys) {
            filtered.count(key, this.get(key));
        }
        return filtered;
    }

    public static enum CompositionalMode {
        ADDITIVE,
        MULTIPLICATIVE;

    }

    public static enum CountThreshold {
        MEAN,
        MEAN_MINUS_STD,
        MEAN_PLUS_STD,
        ABSOLUTE,
        TOP_SCORED;

    }
}

