/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.AbstractSuffixTree;
import it.uniroma1.lcl.jlt.util.SimpleSuffixTree;
import it.uniroma1.lcl.jlt.util.SuffixTreeNode;

public class CompactSuffixTree
extends AbstractSuffixTree {
    public CompactSuffixTree(SimpleSuffixTree simpleSuffixTree) {
        super(simpleSuffixTree.text);
        this.root = this.compactNodes(simpleSuffixTree.root, 0);
    }

    private SuffixTreeNode compactNodes(SuffixTreeNode node, int nodeDepth) {
        node.nodeDepth = nodeDepth;
        for (SuffixTreeNode child : node.children) {
            while (child.children.size() == 1) {
                SuffixTreeNode grandchild = child.children.iterator().next();
                child.incomingEdge.label = String.valueOf(child.incomingEdge.label) + "\t" + grandchild.incomingEdge.label;
                child.stringDepth += grandchild.incomingEdge.label.length();
                child.children = grandchild.children;
            }
            SuffixTreeNode suffixTreeNode = this.compactNodes(child, nodeDepth + 1);
        }
        return node;
    }

    public static void main(String[] args) {
        String[] text = new String[]{"ciao\ta\ttutti", "ciao\ta\tme", "hello\ta\ttutti", "ciao\tdi\tte", "ciao\tdi\tte"};
        CompactSuffixTree t = new CompactSuffixTree(new SimpleSuffixTree(text));
        text = new String[]{"TARGET_NN_NP\tis_VBZ_VP\tNN_NP\tto_TO_PP\tlarge_JJ_PP", "TARGET_NN_NP\tare_VBZ_VP\tNN_NP\tto_TO_PP\tlarge_JJ_PP", "PP_IN_In        PP_JJ_Greek     PP_NN_mythology ,_,     NP_NP_TARGET    (_(     ADVP_RB_also    NP_NN_Akhilleus NP_CC_or        NP_NN_Achilleus :_;     NP_NP_Ancient   NP_NP_Greek     :_:     NP_NP_\u00c3\u00a1\u00c2\u03c0\u00c2\u221a\u00c3\u2202\u00c2\u03a9\u00c3\u2044\u00c2\u2019\u00c3\u2044\u00c2\u00bb\u00c3\u2044\u00c2\u00bb\u00c3\u2044\u00c2\u00b5\u00c3\u2202\u00c2\u0178\u00c3\u2202\u00c2\u2260        )_)     VP_VBD_was      NP_DT_a NP_NP_Greek    NP_NN_hero      PP_IN_of        PP_DT_the       PP_NP_Trojan    PP_NP_War       ,_,     NP_DT_the       NP_JJ_central   NP_NN_character CC_and  NP_DT_the       NP_JJS_greatest NP_NN_warrior   PP_IN_of        PP_NP_Homer     PP_POS_'s       NP_NN_Iliad     ,_,     NP_WDT_whichVP_VVZ_takes    PP_IN_for       PP_PP$_its      PP_NN_theme     NP_DT_the       NP_NN_Wrath     PP_IN_of        PP_NP_Achilles  SENT_."};
        t = new CompactSuffixTree(new SimpleSuffixTree(text));
        System.out.println(t.search("PP_IN_In        PP_JJ_Greek     PP_NN_mythology ,_,     NP_NP_TARGET    (_(     ADVP_RB_also    NP_NN_Akhilleus NP_CC_or        NP_NN_Achilleus :_;     NP_NP_Ancient   NP_NP_Greek     :_:     NP_NP_\u00c3\u00a1\u00c2\u03c0\u00c2\u221a\u00c3\u2202\u00c2\u03a9\u00c3\u2044\u00c2\u2019\u00c3\u2044\u00c2\u00bb\u00c3\u2044\u00c2\u00bb\u00c3\u2044\u00c2\u00b5\u00c3\u2202\u00c2\u0178\u00c3\u2202\u00c2\u2260        )_)     VP_VBD_was      NP_DT_a NP_NP_Greek    NP_NN_hero      PP_IN_of        PP_DT_the       PP_NP_Trojan    PP_NP_War       ,_,     NP_DT_the       NP_JJ_central   NP_NN_character CC_and  NP_DT_the       NP_JJS_greatest NP_NN_warrior   PP_IN_of        PP_NP_Homer     PP_POS_'s       NP_NN_Iliad     ,_,     NP_WDT_whichVP_VVZ_takes    PP_IN_for       PP_PP$_its      PP_NN_theme     NP_DT_the       NP_NN_Wrath     PP_IN_of        PP_NP_Achilles  SENT_."));
    }
}

