/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.Sets;
import it.uniroma1.lcl.jlt.util.Strings;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class CommandLineParser {
    public static Map<String, String> parse(String[] args) {
        return CommandLineParser.parse(args, new HashSet<String>());
    }

    public static Map<String, String> parse(String[] args, Collection<String> noValueParameters) {
        LinkedHashMap<String, String> parse = new LinkedHashMap<String, String>();
        int k = 0;
        while (k < args.length) {
            if (args[k].startsWith("--")) {
                String name = args[k].substring(2);
                String value = null;
                if (!noValueParameters.contains(name)) {
                    value = args[++k];
                }
                parse.put(name, value);
            } else if (args[k].startsWith("-")) {
                String nameValue = args[k].substring(1);
                String name = Strings.prefixUntil(nameValue, '=');
                String value = null;
                if (name.length() < nameValue.length() && !noValueParameters.contains(name)) {
                    value = Strings.suffixUntil(nameValue, '=');
                }
                parse.put(name, value);
            } else {
                parse.put(args[k], null);
            }
            ++k;
        }
        return parse;
    }

    public static void main(String[] args) {
        args = new String[]{"-a=10", "-b", "-c=20", "--parse", "sem", "--test", "testValue", "key"};
        Map<String, String> parse = CommandLineParser.parse(args, Sets.varargsToHashSet("a", "parse"));
        System.out.println(parse);
    }
}

